/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ListenerProtocol {
    HTTP("HTTP"),
    HTTPS("HTTPS"),
    TLS_PASSTHROUGH("TLS_PASSTHROUGH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ListenerProtocol> VALUE_MAP;
    private final String value;

    private ListenerProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ListenerProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ListenerProtocol> knownValues() {
        EnumSet<ListenerProtocol> knownValues = EnumSet.allOf(ListenerProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ListenerProtocol.class, ListenerProtocol::toString);
    }
}

