/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.vpclattice.model.TagMapCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceNetworkServiceAssociationRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, CreateServiceNetworkServiceAssociationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateServiceNetworkServiceAssociationRequest.getter(CreateServiceNetworkServiceAssociationRequest::clientToken)).setter(CreateServiceNetworkServiceAssociationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceIdentifier").getter(CreateServiceNetworkServiceAssociationRequest.getter(CreateServiceNetworkServiceAssociationRequest::serviceIdentifier)).setter(CreateServiceNetworkServiceAssociationRequest.setter(Builder::serviceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceIdentifier").build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkIdentifier").getter(CreateServiceNetworkServiceAssociationRequest.getter(CreateServiceNetworkServiceAssociationRequest::serviceNetworkIdentifier)).setter(CreateServiceNetworkServiceAssociationRequest.setter(Builder::serviceNetworkIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateServiceNetworkServiceAssociationRequest.getter(CreateServiceNetworkServiceAssociationRequest::tags)).setter(CreateServiceNetworkServiceAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, SERVICE_IDENTIFIER_FIELD, SERVICE_NETWORK_IDENTIFIER_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("serviceIdentifier", SERVICE_IDENTIFIER_FIELD);
            this.put("serviceNetworkIdentifier", SERVICE_NETWORK_IDENTIFIER_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clientToken;
    private final String serviceIdentifier;
    private final String serviceNetworkIdentifier;
    private final Map<String, String> tags;

    private CreateServiceNetworkServiceAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.serviceIdentifier = builder.serviceIdentifier;
        this.serviceNetworkIdentifier = builder.serviceNetworkIdentifier;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String serviceIdentifier() {
        return this.serviceIdentifier;
    }

    public final String serviceNetworkIdentifier() {
        return this.serviceNetworkIdentifier;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceNetworkServiceAssociationRequest)) {
            return false;
        }
        CreateServiceNetworkServiceAssociationRequest other = (CreateServiceNetworkServiceAssociationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.serviceIdentifier(), other.serviceIdentifier()) && Objects.equals(this.serviceNetworkIdentifier(), other.serviceNetworkIdentifier()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceNetworkServiceAssociationRequest").add("ClientToken", (Object)this.clientToken()).add("ServiceIdentifier", (Object)this.serviceIdentifier()).add("ServiceNetworkIdentifier", (Object)this.serviceNetworkIdentifier()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "serviceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceIdentifier()));
            }
            case "serviceNetworkIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkIdentifier()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceNetworkServiceAssociationRequest, T> g) {
        return obj -> g.apply((CreateServiceNetworkServiceAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String serviceIdentifier;
        private String serviceNetworkIdentifier;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceNetworkServiceAssociationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.serviceIdentifier(model.serviceIdentifier);
            this.serviceNetworkIdentifier(model.serviceNetworkIdentifier);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getServiceIdentifier() {
            return this.serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final String getServiceNetworkIdentifier() {
            return this.serviceNetworkIdentifier;
        }

        public final void setServiceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
        }

        @Override
        public final Builder serviceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceNetworkServiceAssociationRequest build() {
            return new CreateServiceNetworkServiceAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceNetworkServiceAssociationRequest> {
        public Builder clientToken(String var1);

        public Builder serviceIdentifier(String var1);

        public Builder serviceNetworkIdentifier(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

