/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the watchlists in a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WatchlistDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<WatchlistDetails.Builder, WatchlistDetails> {
    private static final SdkField<String> DEFAULT_WATCHLIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultWatchlistId").getter(getter(WatchlistDetails::defaultWatchlistId))
            .setter(setter(Builder::defaultWatchlistId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultWatchlistId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_WATCHLIST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultWatchlistId;

    private WatchlistDetails(BuilderImpl builder) {
        this.defaultWatchlistId = builder.defaultWatchlistId;
    }

    /**
     * <p>
     * The identifier of the default watchlist.
     * </p>
     * 
     * @return The identifier of the default watchlist.
     */
    public final String defaultWatchlistId() {
        return defaultWatchlistId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultWatchlistId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WatchlistDetails)) {
            return false;
        }
        WatchlistDetails other = (WatchlistDetails) obj;
        return Objects.equals(defaultWatchlistId(), other.defaultWatchlistId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WatchlistDetails").add("DefaultWatchlistId", defaultWatchlistId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultWatchlistId":
            return Optional.ofNullable(clazz.cast(defaultWatchlistId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DefaultWatchlistId", DEFAULT_WATCHLIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WatchlistDetails, T> g) {
        return obj -> g.apply((WatchlistDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WatchlistDetails> {
        /**
         * <p>
         * The identifier of the default watchlist.
         * </p>
         * 
         * @param defaultWatchlistId
         *        The identifier of the default watchlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultWatchlistId(String defaultWatchlistId);
    }

    static final class BuilderImpl implements Builder {
        private String defaultWatchlistId;

        private BuilderImpl() {
        }

        private BuilderImpl(WatchlistDetails model) {
            defaultWatchlistId(model.defaultWatchlistId);
        }

        public final String getDefaultWatchlistId() {
            return defaultWatchlistId;
        }

        public final void setDefaultWatchlistId(String defaultWatchlistId) {
            this.defaultWatchlistId = defaultWatchlistId;
        }

        @Override
        public final Builder defaultWatchlistId(String defaultWatchlistId) {
            this.defaultWatchlistId = defaultWatchlistId;
            return this;
        }

        @Override
        public WatchlistDetails build() {
            return new WatchlistDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
