/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFraudsterRegistrationJobsResponse extends VoiceIdResponse implements
        ToCopyableBuilder<ListFraudsterRegistrationJobsResponse.Builder, ListFraudsterRegistrationJobsResponse> {
    private static final SdkField<List<FraudsterRegistrationJobSummary>> JOB_SUMMARIES_FIELD = SdkField
            .<List<FraudsterRegistrationJobSummary>> builder(MarshallingType.LIST)
            .memberName("JobSummaries")
            .getter(getter(ListFraudsterRegistrationJobsResponse::jobSummaries))
            .setter(setter(Builder::jobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FraudsterRegistrationJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FraudsterRegistrationJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFraudsterRegistrationJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FraudsterRegistrationJobSummary> jobSummaries;

    private final String nextToken;

    private ListFraudsterRegistrationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummaries = builder.jobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobSummaries() {
        return jobSummaries != null && !(jobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing details about each specified fraudster registration job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobSummaries} method.
     * </p>
     * 
     * @return A list containing details about each specified fraudster registration job.
     */
    public final List<FraudsterRegistrationJobSummary> jobSummaries() {
        return jobSummaries;
    }

    /**
     * <p>
     * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours.
     * </p>
     * 
     * @return If <code>NextToken</code> is returned, there are more results available. The value of
     *         <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobSummaries() ? jobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFraudsterRegistrationJobsResponse)) {
            return false;
        }
        ListFraudsterRegistrationJobsResponse other = (ListFraudsterRegistrationJobsResponse) obj;
        return hasJobSummaries() == other.hasJobSummaries() && Objects.equals(jobSummaries(), other.jobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFraudsterRegistrationJobsResponse")
                .add("JobSummaries", hasJobSummaries() ? jobSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobSummaries":
            return Optional.ofNullable(clazz.cast(jobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobSummaries", JOB_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFraudsterRegistrationJobsResponse, T> g) {
        return obj -> g.apply((ListFraudsterRegistrationJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VoiceIdResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFraudsterRegistrationJobsResponse> {
        /**
         * <p>
         * A list containing details about each specified fraudster registration job.
         * </p>
         * 
         * @param jobSummaries
         *        A list containing details about each specified fraudster registration job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaries(Collection<FraudsterRegistrationJobSummary> jobSummaries);

        /**
         * <p>
         * A list containing details about each specified fraudster registration job.
         * </p>
         * 
         * @param jobSummaries
         *        A list containing details about each specified fraudster registration job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSummaries(FraudsterRegistrationJobSummary... jobSummaries);

        /**
         * <p>
         * A list containing details about each specified fraudster registration job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #jobSummaries(List<FraudsterRegistrationJobSummary>)}.
         * 
         * @param jobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSummaries(java.util.Collection<FraudsterRegistrationJobSummary>)
         */
        Builder jobSummaries(Consumer<FraudsterRegistrationJobSummary.Builder>... jobSummaries);

        /**
         * <p>
         * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is returned, there are more results available. The value of
         *        <code>NextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends VoiceIdResponse.BuilderImpl implements Builder {
        private List<FraudsterRegistrationJobSummary> jobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFraudsterRegistrationJobsResponse model) {
            super(model);
            jobSummaries(model.jobSummaries);
            nextToken(model.nextToken);
        }

        public final List<FraudsterRegistrationJobSummary.Builder> getJobSummaries() {
            List<FraudsterRegistrationJobSummary.Builder> result = FraudsterRegistrationJobSummariesCopier
                    .copyToBuilder(this.jobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobSummaries(Collection<FraudsterRegistrationJobSummary.BuilderImpl> jobSummaries) {
            this.jobSummaries = FraudsterRegistrationJobSummariesCopier.copyFromBuilder(jobSummaries);
        }

        @Override
        public final Builder jobSummaries(Collection<FraudsterRegistrationJobSummary> jobSummaries) {
            this.jobSummaries = FraudsterRegistrationJobSummariesCopier.copy(jobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(FraudsterRegistrationJobSummary... jobSummaries) {
            jobSummaries(Arrays.asList(jobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaries(Consumer<FraudsterRegistrationJobSummary.Builder>... jobSummaries) {
            jobSummaries(Stream.of(jobSummaries).map(c -> FraudsterRegistrationJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFraudsterRegistrationJobsResponse build() {
            return new ListFraudsterRegistrationJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
