/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.voiceid.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateFraudsterResponse extends VoiceIdResponse implements
        ToCopyableBuilder<AssociateFraudsterResponse.Builder, AssociateFraudsterResponse> {
    private static final SdkField<Fraudster> FRAUDSTER_FIELD = SdkField.<Fraudster> builder(MarshallingType.SDK_POJO)
            .memberName("Fraudster").getter(getter(AssociateFraudsterResponse::fraudster)).setter(setter(Builder::fraudster))
            .constructor(Fraudster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fraudster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAUDSTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Fraudster fraudster;

    private AssociateFraudsterResponse(BuilderImpl builder) {
        super(builder);
        this.fraudster = builder.fraudster;
    }

    /**
     * Returns the value of the Fraudster property for this object.
     * 
     * @return The value of the Fraudster property for this object.
     */
    public final Fraudster fraudster() {
        return fraudster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fraudster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFraudsterResponse)) {
            return false;
        }
        AssociateFraudsterResponse other = (AssociateFraudsterResponse) obj;
        return Objects.equals(fraudster(), other.fraudster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateFraudsterResponse").add("Fraudster", fraudster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fraudster":
            return Optional.ofNullable(clazz.cast(fraudster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Fraudster", FRAUDSTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateFraudsterResponse, T> g) {
        return obj -> g.apply((AssociateFraudsterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VoiceIdResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssociateFraudsterResponse> {
        /**
         * Sets the value of the Fraudster property for this object.
         *
         * @param fraudster
         *        The new value for the Fraudster property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fraudster(Fraudster fraudster);

        /**
         * Sets the value of the Fraudster property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Fraudster.Builder} avoiding the need to
         * create one manually via {@link Fraudster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Fraudster.Builder#build()} is called immediately and its result
         * is passed to {@link #fraudster(Fraudster)}.
         * 
         * @param fraudster
         *        a consumer that will call methods on {@link Fraudster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fraudster(Fraudster)
         */
        default Builder fraudster(Consumer<Fraudster.Builder> fraudster) {
            return fraudster(Fraudster.builder().applyMutation(fraudster).build());
        }
    }

    static final class BuilderImpl extends VoiceIdResponse.BuilderImpl implements Builder {
        private Fraudster fraudster;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFraudsterResponse model) {
            super(model);
            fraudster(model.fraudster);
        }

        public final Fraudster.Builder getFraudster() {
            return fraudster != null ? fraudster.toBuilder() : null;
        }

        public final void setFraudster(Fraudster.BuilderImpl fraudster) {
            this.fraudster = fraudster != null ? fraudster.build() : null;
        }

        @Override
        public final Builder fraudster(Fraudster fraudster) {
            this.fraudster = fraudster;
            return this;
        }

        @Override
        public AssociateFraudsterResponse build() {
            return new AssociateFraudsterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
