/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.SpeakerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Speaker
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Speaker> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Speaker.getter(Speaker::createdAt)).setter(Speaker.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> CUSTOMER_SPEAKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerSpeakerId").getter(Speaker.getter(Speaker::customerSpeakerId)).setter(Speaker.setter(Builder::customerSpeakerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerSpeakerId").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(Speaker.getter(Speaker::domainId)).setter(Speaker.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> GENERATED_SPEAKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedSpeakerId").getter(Speaker.getter(Speaker::generatedSpeakerId)).setter(Speaker.setter(Builder::generatedSpeakerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedSpeakerId").build()}).build();
    private static final SdkField<Instant> LAST_ACCESSED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAccessedAt").getter(Speaker.getter(Speaker::lastAccessedAt)).setter(Speaker.setter(Builder::lastAccessedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Speaker.getter(Speaker::statusAsString)).setter(Speaker.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(Speaker.getter(Speaker::updatedAt)).setter(Speaker.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CUSTOMER_SPEAKER_ID_FIELD, DOMAIN_ID_FIELD, GENERATED_SPEAKER_ID_FIELD, LAST_ACCESSED_AT_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Speaker.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String customerSpeakerId;
    private final String domainId;
    private final String generatedSpeakerId;
    private final Instant lastAccessedAt;
    private final String status;
    private final Instant updatedAt;

    private Speaker(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.customerSpeakerId = builder.customerSpeakerId;
        this.domainId = builder.domainId;
        this.generatedSpeakerId = builder.generatedSpeakerId;
        this.lastAccessedAt = builder.lastAccessedAt;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String customerSpeakerId() {
        return this.customerSpeakerId;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String generatedSpeakerId() {
        return this.generatedSpeakerId;
    }

    public final Instant lastAccessedAt() {
        return this.lastAccessedAt;
    }

    public final SpeakerStatus status() {
        return SpeakerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedSpeakerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Speaker)) {
            return false;
        }
        Speaker other = (Speaker)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.customerSpeakerId(), other.customerSpeakerId()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.generatedSpeakerId(), other.generatedSpeakerId()) && Objects.equals(this.lastAccessedAt(), other.lastAccessedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"Speaker").add("CreatedAt", (Object)this.createdAt()).add("CustomerSpeakerId", (Object)(this.customerSpeakerId() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("GeneratedSpeakerId", (Object)this.generatedSpeakerId()).add("LastAccessedAt", (Object)this.lastAccessedAt()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CustomerSpeakerId": {
                return Optional.ofNullable(clazz.cast(this.customerSpeakerId()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "GeneratedSpeakerId": {
                return Optional.ofNullable(clazz.cast(this.generatedSpeakerId()));
            }
            case "LastAccessedAt": {
                return Optional.ofNullable(clazz.cast(this.lastAccessedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CustomerSpeakerId", CUSTOMER_SPEAKER_ID_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("GeneratedSpeakerId", GENERATED_SPEAKER_ID_FIELD);
        map.put("LastAccessedAt", LAST_ACCESSED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Speaker, T> g) {
        return obj -> g.apply((Speaker)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String customerSpeakerId;
        private String domainId;
        private String generatedSpeakerId;
        private Instant lastAccessedAt;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Speaker model) {
            this.createdAt(model.createdAt);
            this.customerSpeakerId(model.customerSpeakerId);
            this.domainId(model.domainId);
            this.generatedSpeakerId(model.generatedSpeakerId);
            this.lastAccessedAt(model.lastAccessedAt);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCustomerSpeakerId() {
            return this.customerSpeakerId;
        }

        public final void setCustomerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
        }

        @Override
        public final Builder customerSpeakerId(String customerSpeakerId) {
            this.customerSpeakerId = customerSpeakerId;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGeneratedSpeakerId() {
            return this.generatedSpeakerId;
        }

        public final void setGeneratedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
        }

        @Override
        public final Builder generatedSpeakerId(String generatedSpeakerId) {
            this.generatedSpeakerId = generatedSpeakerId;
            return this;
        }

        public final Instant getLastAccessedAt() {
            return this.lastAccessedAt;
        }

        public final void setLastAccessedAt(Instant lastAccessedAt) {
            this.lastAccessedAt = lastAccessedAt;
        }

        @Override
        public final Builder lastAccessedAt(Instant lastAccessedAt) {
            this.lastAccessedAt = lastAccessedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SpeakerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Speaker build() {
            return new Speaker(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Speaker> {
        public Builder createdAt(Instant var1);

        public Builder customerSpeakerId(String var1);

        public Builder domainId(String var1);

        public Builder generatedSpeakerId(String var1);

        public Builder lastAccessedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(SpeakerStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

