/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FraudDetectionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FraudDetectionConfiguration> {
    private static final SdkField<Integer> RISK_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RiskThreshold").getter(FraudDetectionConfiguration.getter(FraudDetectionConfiguration::riskThreshold)).setter(FraudDetectionConfiguration.setter(Builder::riskThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskThreshold").build()}).build();
    private static final SdkField<String> WATCHLIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WatchlistId").getter(FraudDetectionConfiguration.getter(FraudDetectionConfiguration::watchlistId)).setter(FraudDetectionConfiguration.setter(Builder::watchlistId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WatchlistId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RISK_THRESHOLD_FIELD, WATCHLIST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FraudDetectionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer riskThreshold;
    private final String watchlistId;

    private FraudDetectionConfiguration(BuilderImpl builder) {
        this.riskThreshold = builder.riskThreshold;
        this.watchlistId = builder.watchlistId;
    }

    public final Integer riskThreshold() {
        return this.riskThreshold;
    }

    public final String watchlistId() {
        return this.watchlistId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.riskThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.watchlistId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FraudDetectionConfiguration)) {
            return false;
        }
        FraudDetectionConfiguration other = (FraudDetectionConfiguration)obj;
        return Objects.equals(this.riskThreshold(), other.riskThreshold()) && Objects.equals(this.watchlistId(), other.watchlistId());
    }

    public final String toString() {
        return ToString.builder((String)"FraudDetectionConfiguration").add("RiskThreshold", (Object)this.riskThreshold()).add("WatchlistId", (Object)this.watchlistId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RiskThreshold": {
                return Optional.ofNullable(clazz.cast(this.riskThreshold()));
            }
            case "WatchlistId": {
                return Optional.ofNullable(clazz.cast(this.watchlistId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RiskThreshold", RISK_THRESHOLD_FIELD);
        map.put("WatchlistId", WATCHLIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FraudDetectionConfiguration, T> g) {
        return obj -> g.apply((FraudDetectionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer riskThreshold;
        private String watchlistId;

        private BuilderImpl() {
        }

        private BuilderImpl(FraudDetectionConfiguration model) {
            this.riskThreshold(model.riskThreshold);
            this.watchlistId(model.watchlistId);
        }

        public final Integer getRiskThreshold() {
            return this.riskThreshold;
        }

        public final void setRiskThreshold(Integer riskThreshold) {
            this.riskThreshold = riskThreshold;
        }

        @Override
        public final Builder riskThreshold(Integer riskThreshold) {
            this.riskThreshold = riskThreshold;
            return this;
        }

        public final String getWatchlistId() {
            return this.watchlistId;
        }

        public final void setWatchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
        }

        @Override
        public final Builder watchlistId(String watchlistId) {
            this.watchlistId = watchlistId;
            return this;
        }

        public FraudDetectionConfiguration build() {
            return new FraudDetectionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FraudDetectionConfiguration> {
        public Builder riskThreshold(Integer var1);

        public Builder watchlistId(String var1);
    }
}

