/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.voiceid.model.FraudDetectionConfiguration;
import software.amazon.awssdk.services.voiceid.model.FraudDetectionDecision;
import software.amazon.awssdk.services.voiceid.model.FraudDetectionReason;
import software.amazon.awssdk.services.voiceid.model.FraudDetectionReasonsCopier;
import software.amazon.awssdk.services.voiceid.model.FraudRiskDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FraudDetectionResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FraudDetectionResult> {
    private static final SdkField<Instant> AUDIO_AGGREGATION_ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AudioAggregationEndedAt").getter(FraudDetectionResult.getter(FraudDetectionResult::audioAggregationEndedAt)).setter(FraudDetectionResult.setter(Builder::audioAggregationEndedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioAggregationEndedAt").build()}).build();
    private static final SdkField<Instant> AUDIO_AGGREGATION_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AudioAggregationStartedAt").getter(FraudDetectionResult.getter(FraudDetectionResult::audioAggregationStartedAt)).setter(FraudDetectionResult.setter(Builder::audioAggregationStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioAggregationStartedAt").build()}).build();
    private static final SdkField<FraudDetectionConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(FraudDetectionResult.getter(FraudDetectionResult::configuration)).setter(FraudDetectionResult.setter(Builder::configuration)).constructor(FraudDetectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> DECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Decision").getter(FraudDetectionResult.getter(FraudDetectionResult::decisionAsString)).setter(FraudDetectionResult.setter(Builder::decision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Decision").build()}).build();
    private static final SdkField<String> FRAUD_DETECTION_RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FraudDetectionResultId").getter(FraudDetectionResult.getter(FraudDetectionResult::fraudDetectionResultId)).setter(FraudDetectionResult.setter(Builder::fraudDetectionResultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudDetectionResultId").build()}).build();
    private static final SdkField<List<String>> REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reasons").getter(FraudDetectionResult.getter(FraudDetectionResult::reasonsAsStrings)).setter(FraudDetectionResult.setter(Builder::reasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FraudRiskDetails> RISK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RiskDetails").getter(FraudDetectionResult.getter(FraudDetectionResult::riskDetails)).setter(FraudDetectionResult.setter(Builder::riskDetails)).constructor(FraudRiskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_AGGREGATION_ENDED_AT_FIELD, AUDIO_AGGREGATION_STARTED_AT_FIELD, CONFIGURATION_FIELD, DECISION_FIELD, FRAUD_DETECTION_RESULT_ID_FIELD, REASONS_FIELD, RISK_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FraudDetectionResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant audioAggregationEndedAt;
    private final Instant audioAggregationStartedAt;
    private final FraudDetectionConfiguration configuration;
    private final String decision;
    private final String fraudDetectionResultId;
    private final List<String> reasons;
    private final FraudRiskDetails riskDetails;

    private FraudDetectionResult(BuilderImpl builder) {
        this.audioAggregationEndedAt = builder.audioAggregationEndedAt;
        this.audioAggregationStartedAt = builder.audioAggregationStartedAt;
        this.configuration = builder.configuration;
        this.decision = builder.decision;
        this.fraudDetectionResultId = builder.fraudDetectionResultId;
        this.reasons = builder.reasons;
        this.riskDetails = builder.riskDetails;
    }

    public final Instant audioAggregationEndedAt() {
        return this.audioAggregationEndedAt;
    }

    public final Instant audioAggregationStartedAt() {
        return this.audioAggregationStartedAt;
    }

    public final FraudDetectionConfiguration configuration() {
        return this.configuration;
    }

    public final FraudDetectionDecision decision() {
        return FraudDetectionDecision.fromValue(this.decision);
    }

    public final String decisionAsString() {
        return this.decision;
    }

    public final String fraudDetectionResultId() {
        return this.fraudDetectionResultId;
    }

    public final List<FraudDetectionReason> reasons() {
        return FraudDetectionReasonsCopier.copyStringToEnum(this.reasons);
    }

    public final boolean hasReasons() {
        return this.reasons != null && !(this.reasons instanceof SdkAutoConstructList);
    }

    public final List<String> reasonsAsStrings() {
        return this.reasons;
    }

    public final FraudRiskDetails riskDetails() {
        return this.riskDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioAggregationEndedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioAggregationStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fraudDetectionResultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReasons() ? this.reasonsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.riskDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FraudDetectionResult)) {
            return false;
        }
        FraudDetectionResult other = (FraudDetectionResult)obj;
        return Objects.equals(this.audioAggregationEndedAt(), other.audioAggregationEndedAt()) && Objects.equals(this.audioAggregationStartedAt(), other.audioAggregationStartedAt()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.decisionAsString(), other.decisionAsString()) && Objects.equals(this.fraudDetectionResultId(), other.fraudDetectionResultId()) && this.hasReasons() == other.hasReasons() && Objects.equals(this.reasonsAsStrings(), other.reasonsAsStrings()) && Objects.equals(this.riskDetails(), other.riskDetails());
    }

    public final String toString() {
        return ToString.builder((String)"FraudDetectionResult").add("AudioAggregationEndedAt", (Object)this.audioAggregationEndedAt()).add("AudioAggregationStartedAt", (Object)this.audioAggregationStartedAt()).add("Configuration", (Object)this.configuration()).add("Decision", (Object)this.decisionAsString()).add("FraudDetectionResultId", (Object)this.fraudDetectionResultId()).add("Reasons", this.hasReasons() ? this.reasonsAsStrings() : null).add("RiskDetails", (Object)this.riskDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioAggregationEndedAt": {
                return Optional.ofNullable(clazz.cast(this.audioAggregationEndedAt()));
            }
            case "AudioAggregationStartedAt": {
                return Optional.ofNullable(clazz.cast(this.audioAggregationStartedAt()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Decision": {
                return Optional.ofNullable(clazz.cast(this.decisionAsString()));
            }
            case "FraudDetectionResultId": {
                return Optional.ofNullable(clazz.cast(this.fraudDetectionResultId()));
            }
            case "Reasons": {
                return Optional.ofNullable(clazz.cast(this.reasonsAsStrings()));
            }
            case "RiskDetails": {
                return Optional.ofNullable(clazz.cast(this.riskDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AudioAggregationEndedAt", AUDIO_AGGREGATION_ENDED_AT_FIELD);
        map.put("AudioAggregationStartedAt", AUDIO_AGGREGATION_STARTED_AT_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Decision", DECISION_FIELD);
        map.put("FraudDetectionResultId", FRAUD_DETECTION_RESULT_ID_FIELD);
        map.put("Reasons", REASONS_FIELD);
        map.put("RiskDetails", RISK_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FraudDetectionResult, T> g) {
        return obj -> g.apply((FraudDetectionResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant audioAggregationEndedAt;
        private Instant audioAggregationStartedAt;
        private FraudDetectionConfiguration configuration;
        private String decision;
        private String fraudDetectionResultId;
        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();
        private FraudRiskDetails riskDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(FraudDetectionResult model) {
            this.audioAggregationEndedAt(model.audioAggregationEndedAt);
            this.audioAggregationStartedAt(model.audioAggregationStartedAt);
            this.configuration(model.configuration);
            this.decision(model.decision);
            this.fraudDetectionResultId(model.fraudDetectionResultId);
            this.reasonsWithStrings(model.reasons);
            this.riskDetails(model.riskDetails);
        }

        public final Instant getAudioAggregationEndedAt() {
            return this.audioAggregationEndedAt;
        }

        public final void setAudioAggregationEndedAt(Instant audioAggregationEndedAt) {
            this.audioAggregationEndedAt = audioAggregationEndedAt;
        }

        @Override
        public final Builder audioAggregationEndedAt(Instant audioAggregationEndedAt) {
            this.audioAggregationEndedAt = audioAggregationEndedAt;
            return this;
        }

        public final Instant getAudioAggregationStartedAt() {
            return this.audioAggregationStartedAt;
        }

        public final void setAudioAggregationStartedAt(Instant audioAggregationStartedAt) {
            this.audioAggregationStartedAt = audioAggregationStartedAt;
        }

        @Override
        public final Builder audioAggregationStartedAt(Instant audioAggregationStartedAt) {
            this.audioAggregationStartedAt = audioAggregationStartedAt;
            return this;
        }

        public final FraudDetectionConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(FraudDetectionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FraudDetectionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDecision() {
            return this.decision;
        }

        public final void setDecision(String decision) {
            this.decision = decision;
        }

        @Override
        public final Builder decision(String decision) {
            this.decision = decision;
            return this;
        }

        @Override
        public final Builder decision(FraudDetectionDecision decision) {
            this.decision(decision == null ? null : decision.toString());
            return this;
        }

        public final String getFraudDetectionResultId() {
            return this.fraudDetectionResultId;
        }

        public final void setFraudDetectionResultId(String fraudDetectionResultId) {
            this.fraudDetectionResultId = fraudDetectionResultId;
        }

        @Override
        public final Builder fraudDetectionResultId(String fraudDetectionResultId) {
            this.fraudDetectionResultId = fraudDetectionResultId;
            return this;
        }

        public final Collection<String> getReasons() {
            if (this.reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = FraudDetectionReasonsCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = FraudDetectionReasonsCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String ... reasons) {
            this.reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<FraudDetectionReason> reasons) {
            this.reasons = FraudDetectionReasonsCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(FraudDetectionReason ... reasons) {
            this.reasons(Arrays.asList(reasons));
            return this;
        }

        public final FraudRiskDetails.Builder getRiskDetails() {
            return this.riskDetails != null ? this.riskDetails.toBuilder() : null;
        }

        public final void setRiskDetails(FraudRiskDetails.BuilderImpl riskDetails) {
            this.riskDetails = riskDetails != null ? riskDetails.build() : null;
        }

        @Override
        public final Builder riskDetails(FraudRiskDetails riskDetails) {
            this.riskDetails = riskDetails;
            return this;
        }

        public FraudDetectionResult build() {
            return new FraudDetectionResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FraudDetectionResult> {
        public Builder audioAggregationEndedAt(Instant var1);

        public Builder audioAggregationStartedAt(Instant var1);

        public Builder configuration(FraudDetectionConfiguration var1);

        default public Builder configuration(Consumer<FraudDetectionConfiguration.Builder> configuration) {
            return this.configuration((FraudDetectionConfiguration)((FraudDetectionConfiguration.Builder)FraudDetectionConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder decision(String var1);

        public Builder decision(FraudDetectionDecision var1);

        public Builder fraudDetectionResultId(String var1);

        public Builder reasonsWithStrings(Collection<String> var1);

        public Builder reasonsWithStrings(String ... var1);

        public Builder reasons(Collection<FraudDetectionReason> var1);

        public Builder reasons(FraudDetectionReason ... var1);

        public Builder riskDetails(FraudRiskDetails var1);

        default public Builder riskDetails(Consumer<FraudRiskDetails.Builder> riskDetails) {
            return this.riskDetails((FraudRiskDetails)((FraudRiskDetails.Builder)FraudRiskDetails.builder().applyMutation(riskDetails)).build());
        }
    }
}

