/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdClient;
import software.amazon.awssdk.services.voiceid.internal.UserAgentUtils;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsRequest;
import software.amazon.awssdk.services.voiceid.model.ListSpeakerEnrollmentJobsResponse;
import software.amazon.awssdk.services.voiceid.model.SpeakerEnrollmentJobSummary;

public class ListSpeakerEnrollmentJobsIterable
implements SdkIterable<ListSpeakerEnrollmentJobsResponse> {
    private final VoiceIdClient client;
    private final ListSpeakerEnrollmentJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSpeakerEnrollmentJobsIterable(VoiceIdClient client, ListSpeakerEnrollmentJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSpeakerEnrollmentJobsResponseFetcher();
    }

    public Iterator<ListSpeakerEnrollmentJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpeakerEnrollmentJobSummary> jobSummaries() {
        Function<ListSpeakerEnrollmentJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSpeakerEnrollmentJobsResponseFetcher
    implements SyncPageFetcher<ListSpeakerEnrollmentJobsResponse> {
        private ListSpeakerEnrollmentJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSpeakerEnrollmentJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSpeakerEnrollmentJobsResponse nextPage(ListSpeakerEnrollmentJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSpeakerEnrollmentJobsIterable.this.client.listSpeakerEnrollmentJobs(ListSpeakerEnrollmentJobsIterable.this.firstRequest);
            }
            return ListSpeakerEnrollmentJobsIterable.this.client.listSpeakerEnrollmentJobs((ListSpeakerEnrollmentJobsRequest)((Object)ListSpeakerEnrollmentJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

