/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.KnownFraudsterRisk;
import software.amazon.awssdk.services.voiceid.model.VoiceSpoofingRisk;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FraudRiskDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FraudRiskDetails> {
    private static final SdkField<KnownFraudsterRisk> KNOWN_FRAUDSTER_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KnownFraudsterRisk").getter(FraudRiskDetails.getter(FraudRiskDetails::knownFraudsterRisk)).setter(FraudRiskDetails.setter(Builder::knownFraudsterRisk)).constructor(KnownFraudsterRisk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KnownFraudsterRisk").build()}).build();
    private static final SdkField<VoiceSpoofingRisk> VOICE_SPOOFING_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VoiceSpoofingRisk").getter(FraudRiskDetails.getter(FraudRiskDetails::voiceSpoofingRisk)).setter(FraudRiskDetails.setter(Builder::voiceSpoofingRisk)).constructor(VoiceSpoofingRisk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceSpoofingRisk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWN_FRAUDSTER_RISK_FIELD, VOICE_SPOOFING_RISK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KnownFraudsterRisk", KNOWN_FRAUDSTER_RISK_FIELD);
            this.put("VoiceSpoofingRisk", VOICE_SPOOFING_RISK_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final KnownFraudsterRisk knownFraudsterRisk;
    private final VoiceSpoofingRisk voiceSpoofingRisk;

    private FraudRiskDetails(BuilderImpl builder) {
        this.knownFraudsterRisk = builder.knownFraudsterRisk;
        this.voiceSpoofingRisk = builder.voiceSpoofingRisk;
    }

    public final KnownFraudsterRisk knownFraudsterRisk() {
        return this.knownFraudsterRisk;
    }

    public final VoiceSpoofingRisk voiceSpoofingRisk() {
        return this.voiceSpoofingRisk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knownFraudsterRisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceSpoofingRisk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FraudRiskDetails)) {
            return false;
        }
        FraudRiskDetails other = (FraudRiskDetails)obj;
        return Objects.equals(this.knownFraudsterRisk(), other.knownFraudsterRisk()) && Objects.equals(this.voiceSpoofingRisk(), other.voiceSpoofingRisk());
    }

    public final String toString() {
        return ToString.builder((String)"FraudRiskDetails").add("KnownFraudsterRisk", (Object)this.knownFraudsterRisk()).add("VoiceSpoofingRisk", (Object)this.voiceSpoofingRisk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KnownFraudsterRisk": {
                return Optional.ofNullable(clazz.cast(this.knownFraudsterRisk()));
            }
            case "VoiceSpoofingRisk": {
                return Optional.ofNullable(clazz.cast(this.voiceSpoofingRisk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FraudRiskDetails, T> g) {
        return obj -> g.apply((FraudRiskDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KnownFraudsterRisk knownFraudsterRisk;
        private VoiceSpoofingRisk voiceSpoofingRisk;

        private BuilderImpl() {
        }

        private BuilderImpl(FraudRiskDetails model) {
            this.knownFraudsterRisk(model.knownFraudsterRisk);
            this.voiceSpoofingRisk(model.voiceSpoofingRisk);
        }

        public final KnownFraudsterRisk.Builder getKnownFraudsterRisk() {
            return this.knownFraudsterRisk != null ? this.knownFraudsterRisk.toBuilder() : null;
        }

        public final void setKnownFraudsterRisk(KnownFraudsterRisk.BuilderImpl knownFraudsterRisk) {
            this.knownFraudsterRisk = knownFraudsterRisk != null ? knownFraudsterRisk.build() : null;
        }

        @Override
        public final Builder knownFraudsterRisk(KnownFraudsterRisk knownFraudsterRisk) {
            this.knownFraudsterRisk = knownFraudsterRisk;
            return this;
        }

        public final VoiceSpoofingRisk.Builder getVoiceSpoofingRisk() {
            return this.voiceSpoofingRisk != null ? this.voiceSpoofingRisk.toBuilder() : null;
        }

        public final void setVoiceSpoofingRisk(VoiceSpoofingRisk.BuilderImpl voiceSpoofingRisk) {
            this.voiceSpoofingRisk = voiceSpoofingRisk != null ? voiceSpoofingRisk.build() : null;
        }

        @Override
        public final Builder voiceSpoofingRisk(VoiceSpoofingRisk voiceSpoofingRisk) {
            this.voiceSpoofingRisk = voiceSpoofingRisk;
            return this;
        }

        public FraudRiskDetails build() {
            return new FraudRiskDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FraudRiskDetails> {
        public Builder knownFraudsterRisk(KnownFraudsterRisk var1);

        default public Builder knownFraudsterRisk(Consumer<KnownFraudsterRisk.Builder> knownFraudsterRisk) {
            return this.knownFraudsterRisk((KnownFraudsterRisk)((KnownFraudsterRisk.Builder)KnownFraudsterRisk.builder().applyMutation(knownFraudsterRisk)).build());
        }

        public Builder voiceSpoofingRisk(VoiceSpoofingRisk var1);

        default public Builder voiceSpoofingRisk(Consumer<VoiceSpoofingRisk.Builder> voiceSpoofingRisk) {
            return this.voiceSpoofingRisk((VoiceSpoofingRisk)((VoiceSpoofingRisk.Builder)VoiceSpoofingRisk.builder().applyMutation(voiceSpoofingRisk)).build());
        }
    }
}

