/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdAsyncClient;
import software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest;
import software.amazon.awssdk.services.voiceid.model.ListWatchlistsResponse;
import software.amazon.awssdk.services.voiceid.model.WatchlistSummary;

public class ListWatchlistsPublisher
implements SdkPublisher<ListWatchlistsResponse> {
    private final VoiceIdAsyncClient client;
    private final ListWatchlistsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWatchlistsPublisher(VoiceIdAsyncClient client, ListWatchlistsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWatchlistsPublisher(VoiceIdAsyncClient client, ListWatchlistsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWatchlistsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWatchlistsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WatchlistSummary> watchlistSummaries() {
        Function<ListWatchlistsResponse, Iterator> getIterator = response -> {
            if (response != null && response.watchlistSummaries() != null) {
                return response.watchlistSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWatchlistsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWatchlistsResponseFetcher
    implements AsyncPageFetcher<ListWatchlistsResponse> {
        private ListWatchlistsResponseFetcher() {
        }

        public boolean hasNextPage(ListWatchlistsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWatchlistsResponse> nextPage(ListWatchlistsResponse previousPage) {
            if (previousPage == null) {
                return ListWatchlistsPublisher.this.client.listWatchlists(ListWatchlistsPublisher.this.firstRequest);
            }
            return ListWatchlistsPublisher.this.client.listWatchlists((ListWatchlistsRequest)((Object)ListWatchlistsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

