/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.voiceid.VoiceIdClient;
import software.amazon.awssdk.services.voiceid.model.ListWatchlistsRequest;
import software.amazon.awssdk.services.voiceid.model.ListWatchlistsResponse;
import software.amazon.awssdk.services.voiceid.model.WatchlistSummary;

public class ListWatchlistsIterable
implements SdkIterable<ListWatchlistsResponse> {
    private final VoiceIdClient client;
    private final ListWatchlistsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWatchlistsIterable(VoiceIdClient client, ListWatchlistsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWatchlistsResponseFetcher();
    }

    public Iterator<ListWatchlistsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WatchlistSummary> watchlistSummaries() {
        Function<ListWatchlistsResponse, Iterator> getIterator = response -> {
            if (response != null && response.watchlistSummaries() != null) {
                return response.watchlistSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWatchlistsResponseFetcher
    implements SyncPageFetcher<ListWatchlistsResponse> {
        private ListWatchlistsResponseFetcher() {
        }

        public boolean hasNextPage(ListWatchlistsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWatchlistsResponse nextPage(ListWatchlistsResponse previousPage) {
            if (previousPage == null) {
                return ListWatchlistsIterable.this.client.listWatchlists(ListWatchlistsIterable.this.firstRequest);
            }
            return ListWatchlistsIterable.this.client.listWatchlists((ListWatchlistsRequest)((Object)ListWatchlistsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

