/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.DuplicateRegistrationAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegistrationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegistrationConfig> {
    private static final SdkField<String> DUPLICATE_REGISTRATION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DuplicateRegistrationAction").getter(RegistrationConfig.getter(RegistrationConfig::duplicateRegistrationActionAsString)).setter(RegistrationConfig.setter(Builder::duplicateRegistrationAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DuplicateRegistrationAction").build()}).build();
    private static final SdkField<Integer> FRAUDSTER_SIMILARITY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FraudsterSimilarityThreshold").getter(RegistrationConfig.getter(RegistrationConfig::fraudsterSimilarityThreshold)).setter(RegistrationConfig.setter(Builder::fraudsterSimilarityThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudsterSimilarityThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DUPLICATE_REGISTRATION_ACTION_FIELD, FRAUDSTER_SIMILARITY_THRESHOLD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String duplicateRegistrationAction;
    private final Integer fraudsterSimilarityThreshold;

    private RegistrationConfig(BuilderImpl builder) {
        this.duplicateRegistrationAction = builder.duplicateRegistrationAction;
        this.fraudsterSimilarityThreshold = builder.fraudsterSimilarityThreshold;
    }

    public final DuplicateRegistrationAction duplicateRegistrationAction() {
        return DuplicateRegistrationAction.fromValue(this.duplicateRegistrationAction);
    }

    public final String duplicateRegistrationActionAsString() {
        return this.duplicateRegistrationAction;
    }

    public final Integer fraudsterSimilarityThreshold() {
        return this.fraudsterSimilarityThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.duplicateRegistrationActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fraudsterSimilarityThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistrationConfig)) {
            return false;
        }
        RegistrationConfig other = (RegistrationConfig)obj;
        return Objects.equals(this.duplicateRegistrationActionAsString(), other.duplicateRegistrationActionAsString()) && Objects.equals(this.fraudsterSimilarityThreshold(), other.fraudsterSimilarityThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"RegistrationConfig").add("DuplicateRegistrationAction", (Object)this.duplicateRegistrationActionAsString()).add("FraudsterSimilarityThreshold", (Object)this.fraudsterSimilarityThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DuplicateRegistrationAction": {
                return Optional.ofNullable(clazz.cast(this.duplicateRegistrationActionAsString()));
            }
            case "FraudsterSimilarityThreshold": {
                return Optional.ofNullable(clazz.cast(this.fraudsterSimilarityThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegistrationConfig, T> g) {
        return obj -> g.apply((RegistrationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String duplicateRegistrationAction;
        private Integer fraudsterSimilarityThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistrationConfig model) {
            this.duplicateRegistrationAction(model.duplicateRegistrationAction);
            this.fraudsterSimilarityThreshold(model.fraudsterSimilarityThreshold);
        }

        public final String getDuplicateRegistrationAction() {
            return this.duplicateRegistrationAction;
        }

        public final void setDuplicateRegistrationAction(String duplicateRegistrationAction) {
            this.duplicateRegistrationAction = duplicateRegistrationAction;
        }

        @Override
        public final Builder duplicateRegistrationAction(String duplicateRegistrationAction) {
            this.duplicateRegistrationAction = duplicateRegistrationAction;
            return this;
        }

        @Override
        public final Builder duplicateRegistrationAction(DuplicateRegistrationAction duplicateRegistrationAction) {
            this.duplicateRegistrationAction(duplicateRegistrationAction == null ? null : duplicateRegistrationAction.toString());
            return this;
        }

        public final Integer getFraudsterSimilarityThreshold() {
            return this.fraudsterSimilarityThreshold;
        }

        public final void setFraudsterSimilarityThreshold(Integer fraudsterSimilarityThreshold) {
            this.fraudsterSimilarityThreshold = fraudsterSimilarityThreshold;
        }

        @Override
        public final Builder fraudsterSimilarityThreshold(Integer fraudsterSimilarityThreshold) {
            this.fraudsterSimilarityThreshold = fraudsterSimilarityThreshold;
            return this;
        }

        public RegistrationConfig build() {
            return new RegistrationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegistrationConfig> {
        public Builder duplicateRegistrationAction(String var1);

        public Builder duplicateRegistrationAction(DuplicateRegistrationAction var1);

        public Builder fraudsterSimilarityThreshold(Integer var1);
    }
}

