/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.FraudDetectionAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnrollmentJobFraudDetectionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnrollmentJobFraudDetectionConfig> {
    private static final SdkField<String> FRAUD_DETECTION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FraudDetectionAction").getter(EnrollmentJobFraudDetectionConfig.getter(EnrollmentJobFraudDetectionConfig::fraudDetectionActionAsString)).setter(EnrollmentJobFraudDetectionConfig.setter(Builder::fraudDetectionAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FraudDetectionAction").build()}).build();
    private static final SdkField<Integer> RISK_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RiskThreshold").getter(EnrollmentJobFraudDetectionConfig.getter(EnrollmentJobFraudDetectionConfig::riskThreshold)).setter(EnrollmentJobFraudDetectionConfig.setter(Builder::riskThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAUD_DETECTION_ACTION_FIELD, RISK_THRESHOLD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fraudDetectionAction;
    private final Integer riskThreshold;

    private EnrollmentJobFraudDetectionConfig(BuilderImpl builder) {
        this.fraudDetectionAction = builder.fraudDetectionAction;
        this.riskThreshold = builder.riskThreshold;
    }

    public final FraudDetectionAction fraudDetectionAction() {
        return FraudDetectionAction.fromValue(this.fraudDetectionAction);
    }

    public final String fraudDetectionActionAsString() {
        return this.fraudDetectionAction;
    }

    public final Integer riskThreshold() {
        return this.riskThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fraudDetectionActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnrollmentJobFraudDetectionConfig)) {
            return false;
        }
        EnrollmentJobFraudDetectionConfig other = (EnrollmentJobFraudDetectionConfig)obj;
        return Objects.equals(this.fraudDetectionActionAsString(), other.fraudDetectionActionAsString()) && Objects.equals(this.riskThreshold(), other.riskThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"EnrollmentJobFraudDetectionConfig").add("FraudDetectionAction", (Object)this.fraudDetectionActionAsString()).add("RiskThreshold", (Object)this.riskThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FraudDetectionAction": {
                return Optional.ofNullable(clazz.cast(this.fraudDetectionActionAsString()));
            }
            case "RiskThreshold": {
                return Optional.ofNullable(clazz.cast(this.riskThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnrollmentJobFraudDetectionConfig, T> g) {
        return obj -> g.apply((EnrollmentJobFraudDetectionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fraudDetectionAction;
        private Integer riskThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(EnrollmentJobFraudDetectionConfig model) {
            this.fraudDetectionAction(model.fraudDetectionAction);
            this.riskThreshold(model.riskThreshold);
        }

        public final String getFraudDetectionAction() {
            return this.fraudDetectionAction;
        }

        public final void setFraudDetectionAction(String fraudDetectionAction) {
            this.fraudDetectionAction = fraudDetectionAction;
        }

        @Override
        public final Builder fraudDetectionAction(String fraudDetectionAction) {
            this.fraudDetectionAction = fraudDetectionAction;
            return this;
        }

        @Override
        public final Builder fraudDetectionAction(FraudDetectionAction fraudDetectionAction) {
            this.fraudDetectionAction(fraudDetectionAction == null ? null : fraudDetectionAction.toString());
            return this;
        }

        public final Integer getRiskThreshold() {
            return this.riskThreshold;
        }

        public final void setRiskThreshold(Integer riskThreshold) {
            this.riskThreshold = riskThreshold;
        }

        @Override
        public final Builder riskThreshold(Integer riskThreshold) {
            this.riskThreshold = riskThreshold;
            return this;
        }

        public EnrollmentJobFraudDetectionConfig build() {
            return new EnrollmentJobFraudDetectionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnrollmentJobFraudDetectionConfig> {
        public Builder fraudDetectionAction(String var1);

        public Builder fraudDetectionAction(FraudDetectionAction var1);

        public Builder riskThreshold(Integer var1);
    }
}

