/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConflictType {
    ANOTHER_ACTIVE_STREAM("ANOTHER_ACTIVE_STREAM"),
    DOMAIN_NOT_ACTIVE("DOMAIN_NOT_ACTIVE"),
    CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT("CANNOT_CHANGE_SPEAKER_AFTER_ENROLLMENT"),
    ENROLLMENT_ALREADY_EXISTS("ENROLLMENT_ALREADY_EXISTS"),
    SPEAKER_NOT_SET("SPEAKER_NOT_SET"),
    SPEAKER_OPTED_OUT("SPEAKER_OPTED_OUT"),
    CONCURRENT_CHANGES("CONCURRENT_CHANGES"),
    DOMAIN_LOCKED_FROM_ENCRYPTION_UPDATES("DOMAIN_LOCKED_FROM_ENCRYPTION_UPDATES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConflictType> VALUE_MAP;
    private final String value;

    private ConflictType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConflictType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConflictType> knownValues() {
        EnumSet<ConflictType> knownValues = EnumSet.allOf(ConflictType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConflictType.class, ConflictType::toString);
    }
}

