/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.voiceid.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.voiceid.model.FailureDetails;
import software.amazon.awssdk.services.voiceid.model.FraudsterRegistrationJobStatus;
import software.amazon.awssdk.services.voiceid.model.JobProgress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FraudsterRegistrationJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FraudsterRegistrationJobSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(FraudsterRegistrationJobSummary.getter(FraudsterRegistrationJobSummary::createdAt)).setter(FraudsterRegistrationJobSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(FraudsterRegistrationJobSummary.getter(FraudsterRegistrationJobSummary::domainId)).setter(FraudsterRegistrationJobSummary.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(FraudsterRegistrationJobSummary.getter(FraudsterRegistrationJobSummary::endedAt)).setter(FraudsterRegistrationJobSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build()}).build();
    private static final SdkField<FailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(FraudsterRegistrationJobSummary.getter(FraudsterRegistrationJobSummary::failureDetails)).setter(FraudsterRegistrationJobSummary.setter(Builder::failureDetails)).constructor(FailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(FraudsterRegistrationJobSummary.getter(FraudsterRegistrationJobSummary::jobId)).setter(FraudsterRegistrationJobSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(FraudsterRegistrationJobSummary.getter(FraudsterRegistrationJobSummary::jobName)).setter(FraudsterRegistrationJobSummary.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<JobProgress> JOB_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobProgress").getter(FraudsterRegistrationJobSummary.getter(FraudsterRegistrationJobSummary::jobProgress)).setter(FraudsterRegistrationJobSummary.setter(Builder::jobProgress)).constructor(JobProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobProgress").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(FraudsterRegistrationJobSummary.getter(FraudsterRegistrationJobSummary::jobStatusAsString)).setter(FraudsterRegistrationJobSummary.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DOMAIN_ID_FIELD, ENDED_AT_FIELD, FAILURE_DETAILS_FIELD, JOB_ID_FIELD, JOB_NAME_FIELD, JOB_PROGRESS_FIELD, JOB_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String domainId;
    private final Instant endedAt;
    private final FailureDetails failureDetails;
    private final String jobId;
    private final String jobName;
    private final JobProgress jobProgress;
    private final String jobStatus;

    private FraudsterRegistrationJobSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.domainId = builder.domainId;
        this.endedAt = builder.endedAt;
        this.failureDetails = builder.failureDetails;
        this.jobId = builder.jobId;
        this.jobName = builder.jobName;
        this.jobProgress = builder.jobProgress;
        this.jobStatus = builder.jobStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final FailureDetails failureDetails() {
        return this.failureDetails;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobProgress jobProgress() {
        return this.jobProgress;
    }

    public final FraudsterRegistrationJobStatus jobStatus() {
        return FraudsterRegistrationJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FraudsterRegistrationJobSummary)) {
            return false;
        }
        FraudsterRegistrationJobSummary other = (FraudsterRegistrationJobSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobProgress(), other.jobProgress()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FraudsterRegistrationJobSummary").add("CreatedAt", (Object)this.createdAt()).add("DomainId", (Object)this.domainId()).add("EndedAt", (Object)this.endedAt()).add("FailureDetails", (Object)this.failureDetails()).add("JobId", (Object)this.jobId()).add("JobName", (Object)(this.jobName() == null ? null : "*** Sensitive Data Redacted ***")).add("JobProgress", (Object)this.jobProgress()).add("JobStatus", (Object)this.jobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobProgress": {
                return Optional.ofNullable(clazz.cast(this.jobProgress()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FraudsterRegistrationJobSummary, T> g) {
        return obj -> g.apply((FraudsterRegistrationJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String domainId;
        private Instant endedAt;
        private FailureDetails failureDetails;
        private String jobId;
        private String jobName;
        private JobProgress jobProgress;
        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(FraudsterRegistrationJobSummary model) {
            this.createdAt(model.createdAt);
            this.domainId(model.domainId);
            this.endedAt(model.endedAt);
            this.failureDetails(model.failureDetails);
            this.jobId(model.jobId);
            this.jobName(model.jobName);
            this.jobProgress(model.jobProgress);
            this.jobStatus(model.jobStatus);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        @Transient
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        @Transient
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final JobProgress.Builder getJobProgress() {
            return this.jobProgress != null ? this.jobProgress.toBuilder() : null;
        }

        public final void setJobProgress(JobProgress.BuilderImpl jobProgress) {
            this.jobProgress = jobProgress != null ? jobProgress.build() : null;
        }

        @Override
        @Transient
        public final Builder jobProgress(JobProgress jobProgress) {
            this.jobProgress = jobProgress;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        @Transient
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder jobStatus(FraudsterRegistrationJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public FraudsterRegistrationJobSummary build() {
            return new FraudsterRegistrationJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FraudsterRegistrationJobSummary> {
        public Builder createdAt(Instant var1);

        public Builder domainId(String var1);

        public Builder endedAt(Instant var1);

        public Builder failureDetails(FailureDetails var1);

        default public Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return this.failureDetails((FailureDetails)((FailureDetails.Builder)FailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder jobId(String var1);

        public Builder jobName(String var1);

        public Builder jobProgress(JobProgress var1);

        default public Builder jobProgress(Consumer<JobProgress.Builder> jobProgress) {
            return this.jobProgress((JobProgress)((JobProgress.Builder)JobProgress.builder().applyMutation(jobProgress)).build());
        }

        public Builder jobStatus(String var1);

        public Builder jobStatus(FraudsterRegistrationJobStatus var1);
    }
}

