/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.verifiedpermissions.model.CedarTagRecordAttributeCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.CedarTagSetAttributeCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CedarTagValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CedarTagValue> {
    private static final SdkField<Boolean> BOOLEAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("boolean").getter(CedarTagValue.getter(CedarTagValue::booleanValue)).setter(CedarTagValue.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boolean").build()}).build();
    private static final SdkField<EntityIdentifier> ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("entityIdentifier").getter(CedarTagValue.getter(CedarTagValue::entityIdentifier)).setter(CedarTagValue.setter(Builder::entityIdentifier)).constructor(EntityIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityIdentifier").build()}).build();
    private static final SdkField<Long> LONG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("long").getter(CedarTagValue.getter(CedarTagValue::longValue)).setter(CedarTagValue.setter(Builder::longValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("long").build()}).build();
    private static final SdkField<String> STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("string").getter(CedarTagValue.getter(CedarTagValue::string)).setter(CedarTagValue.setter(Builder::string)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("string").build()}).build();
    private static final SdkField<List<CedarTagValue>> SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("set").getter(CedarTagValue.getter(CedarTagValue::set)).setter(CedarTagValue.setter(Builder::set)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("set").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CedarTagValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CedarTagValue>> RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("record").getter(CedarTagValue.getter(CedarTagValue::record)).setter(CedarTagValue.setter(Builder::record)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("record").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CedarTagValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IPADDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipaddr").getter(CedarTagValue.getter(CedarTagValue::ipaddr)).setter(CedarTagValue.setter(Builder::ipaddr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipaddr").build()}).build();
    private static final SdkField<String> DECIMAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decimal").getter(CedarTagValue.getter(CedarTagValue::decimal)).setter(CedarTagValue.setter(Builder::decimal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decimal").build()}).build();
    private static final SdkField<String> DATETIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datetime").getter(CedarTagValue.getter(CedarTagValue::datetime)).setter(CedarTagValue.setter(Builder::datetime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datetime").build()}).build();
    private static final SdkField<String> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("duration").getter(CedarTagValue.getter(CedarTagValue::duration)).setter(CedarTagValue.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_FIELD, ENTITY_IDENTIFIER_FIELD, LONG_FIELD, STRING_FIELD, SET_FIELD, RECORD_FIELD, IPADDR_FIELD, DECIMAL_FIELD, DATETIME_FIELD, DURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CedarTagValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean booleanValue;
    private final EntityIdentifier entityIdentifier;
    private final Long longValue;
    private final String string;
    private final List<CedarTagValue> set;
    private final Map<String, CedarTagValue> record;
    private final String ipaddr;
    private final String decimal;
    private final String datetime;
    private final String duration;
    private final Type type;

    private CedarTagValue(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.entityIdentifier = builder.entityIdentifier;
        this.longValue = builder.longValue;
        this.string = builder.string;
        this.set = builder.set;
        this.record = builder.record;
        this.ipaddr = builder.ipaddr;
        this.decimal = builder.decimal;
        this.datetime = builder.datetime;
        this.duration = builder.duration;
        this.type = builder.type;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final EntityIdentifier entityIdentifier() {
        return this.entityIdentifier;
    }

    public final Long longValue() {
        return this.longValue;
    }

    public final String string() {
        return this.string;
    }

    public final boolean hasSet() {
        return this.set != null && !(this.set instanceof SdkAutoConstructList);
    }

    public final List<CedarTagValue> set() {
        return this.set;
    }

    public final boolean hasRecord() {
        return this.record != null && !(this.record instanceof SdkAutoConstructMap);
    }

    public final Map<String, CedarTagValue> record() {
        return this.record;
    }

    public final String ipaddr() {
        return this.ipaddr;
    }

    public final String decimal() {
        return this.decimal;
    }

    public final String datetime() {
        return this.datetime;
    }

    public final String duration() {
        return this.duration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.longValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.string());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSet() ? this.set() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecord() ? this.record() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipaddr());
        hashCode = 31 * hashCode + Objects.hashCode(this.decimal());
        hashCode = 31 * hashCode + Objects.hashCode(this.datetime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CedarTagValue)) {
            return false;
        }
        CedarTagValue other = (CedarTagValue)obj;
        return Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.longValue(), other.longValue()) && Objects.equals(this.string(), other.string()) && this.hasSet() == other.hasSet() && Objects.equals(this.set(), other.set()) && this.hasRecord() == other.hasRecord() && Objects.equals(this.record(), other.record()) && Objects.equals(this.ipaddr(), other.ipaddr()) && Objects.equals(this.decimal(), other.decimal()) && Objects.equals(this.datetime(), other.datetime()) && Objects.equals(this.duration(), other.duration());
    }

    public final String toString() {
        return ToString.builder((String)"CedarTagValue").add("Boolean", (Object)(this.booleanValue() == null ? null : "*** Sensitive Data Redacted ***")).add("EntityIdentifier", (Object)this.entityIdentifier()).add("Long", (Object)(this.longValue() == null ? null : "*** Sensitive Data Redacted ***")).add("String", (Object)(this.string() == null ? null : "*** Sensitive Data Redacted ***")).add("Set", this.hasSet() ? this.set() : null).add("Record", this.hasRecord() ? this.record() : null).add("Ipaddr", (Object)(this.ipaddr() == null ? null : "*** Sensitive Data Redacted ***")).add("Decimal", (Object)(this.decimal() == null ? null : "*** Sensitive Data Redacted ***")).add("Datetime", (Object)(this.datetime() == null ? null : "*** Sensitive Data Redacted ***")).add("Duration", (Object)(this.duration() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "boolean": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "entityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "long": {
                return Optional.ofNullable(clazz.cast(this.longValue()));
            }
            case "string": {
                return Optional.ofNullable(clazz.cast(this.string()));
            }
            case "set": {
                return Optional.ofNullable(clazz.cast(this.set()));
            }
            case "record": {
                return Optional.ofNullable(clazz.cast(this.record()));
            }
            case "ipaddr": {
                return Optional.ofNullable(clazz.cast(this.ipaddr()));
            }
            case "decimal": {
                return Optional.ofNullable(clazz.cast(this.decimal()));
            }
            case "datetime": {
                return Optional.ofNullable(clazz.cast(this.datetime()));
            }
            case "duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
        }
        return Optional.empty();
    }

    public static CedarTagValue fromBooleanValue(Boolean booleanValue) {
        return (CedarTagValue)CedarTagValue.builder().booleanValue(booleanValue).build();
    }

    public static CedarTagValue fromEntityIdentifier(EntityIdentifier entityIdentifier) {
        return (CedarTagValue)CedarTagValue.builder().entityIdentifier(entityIdentifier).build();
    }

    public static CedarTagValue fromEntityIdentifier(Consumer<EntityIdentifier.Builder> entityIdentifier) {
        EntityIdentifier.Builder builder = EntityIdentifier.builder();
        entityIdentifier.accept(builder);
        return CedarTagValue.fromEntityIdentifier((EntityIdentifier)builder.build());
    }

    public static CedarTagValue fromLongValue(Long longValue) {
        return (CedarTagValue)CedarTagValue.builder().longValue(longValue).build();
    }

    public static CedarTagValue fromString(String string) {
        return (CedarTagValue)CedarTagValue.builder().string(string).build();
    }

    public static CedarTagValue fromSet(List<CedarTagValue> set) {
        return (CedarTagValue)CedarTagValue.builder().set(set).build();
    }

    public static CedarTagValue fromRecord(Map<String, CedarTagValue> record) {
        return (CedarTagValue)CedarTagValue.builder().record(record).build();
    }

    public static CedarTagValue fromIpaddr(String ipaddr) {
        return (CedarTagValue)CedarTagValue.builder().ipaddr(ipaddr).build();
    }

    public static CedarTagValue fromDecimal(String decimal) {
        return (CedarTagValue)CedarTagValue.builder().decimal(decimal).build();
    }

    public static CedarTagValue fromDatetime(String datetime) {
        return (CedarTagValue)CedarTagValue.builder().datetime(datetime).build();
    }

    public static CedarTagValue fromDuration(String duration) {
        return (CedarTagValue)CedarTagValue.builder().duration(duration).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("boolean", BOOLEAN_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("long", LONG_FIELD);
        map.put("string", STRING_FIELD);
        map.put("set", SET_FIELD);
        map.put("record", RECORD_FIELD);
        map.put("ipaddr", IPADDR_FIELD);
        map.put("decimal", DECIMAL_FIELD);
        map.put("datetime", DATETIME_FIELD);
        map.put("duration", DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CedarTagValue, T> g) {
        return obj -> g.apply((CedarTagValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BOOLEAN,
        ENTITY_IDENTIFIER,
        LONG,
        STRING,
        SET,
        RECORD,
        IPADDR,
        DECIMAL,
        DATETIME,
        DURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Boolean booleanValue;
        private EntityIdentifier entityIdentifier;
        private Long longValue;
        private String string;
        private List<CedarTagValue> set = DefaultSdkAutoConstructList.getInstance();
        private Map<String, CedarTagValue> record = DefaultSdkAutoConstructMap.getInstance();
        private String ipaddr;
        private String decimal;
        private String datetime;
        private String duration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CedarTagValue model) {
            this.booleanValue(model.booleanValue);
            this.entityIdentifier(model.entityIdentifier);
            this.longValue(model.longValue);
            this.string(model.string);
            this.set(model.set);
            this.record(model.record);
            this.ipaddr(model.ipaddr);
            this.decimal(model.decimal);
            this.datetime(model.datetime);
            this.duration(model.duration);
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN, oldValue, this.booleanValue);
            return this;
        }

        public final EntityIdentifier.Builder getEntityIdentifier() {
            return this.entityIdentifier != null ? this.entityIdentifier.toBuilder() : null;
        }

        public final void setEntityIdentifier(EntityIdentifier.BuilderImpl entityIdentifier) {
            EntityIdentifier oldValue = this.entityIdentifier;
            this.entityIdentifier = entityIdentifier != null ? entityIdentifier.build() : null;
            this.handleUnionValueChange(Type.ENTITY_IDENTIFIER, oldValue, this.entityIdentifier);
        }

        @Override
        public final Builder entityIdentifier(EntityIdentifier entityIdentifier) {
            EntityIdentifier oldValue = this.entityIdentifier;
            this.entityIdentifier = entityIdentifier;
            this.handleUnionValueChange(Type.ENTITY_IDENTIFIER, oldValue, this.entityIdentifier);
            return this;
        }

        public final Long getLongValue() {
            return this.longValue;
        }

        public final void setLongValue(Long longValue) {
            Long oldValue = this.longValue;
            this.longValue = longValue;
            this.handleUnionValueChange(Type.LONG, oldValue, this.longValue);
        }

        @Override
        public final Builder longValue(Long longValue) {
            Long oldValue = this.longValue;
            this.longValue = longValue;
            this.handleUnionValueChange(Type.LONG, oldValue, this.longValue);
            return this;
        }

        public final String getString() {
            return this.string;
        }

        public final void setString(String string) {
            String oldValue = this.string;
            this.string = string;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
        }

        @Override
        public final Builder string(String string) {
            String oldValue = this.string;
            this.string = string;
            this.handleUnionValueChange(Type.STRING, oldValue, this.string);
            return this;
        }

        public final List<Builder> getSet() {
            List<Builder> result = CedarTagSetAttributeCopier.copyToBuilder(this.set);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSet(Collection<BuilderImpl> set) {
            List<CedarTagValue> oldValue = this.set;
            this.set = CedarTagSetAttributeCopier.copyFromBuilder(set);
            this.handleUnionValueChange(Type.SET, oldValue, this.set);
        }

        @Override
        @Transient
        public final Builder set(Collection<CedarTagValue> set) {
            List<CedarTagValue> oldValue = this.set;
            this.set = CedarTagSetAttributeCopier.copy(set);
            this.handleUnionValueChange(Type.SET, oldValue, this.set);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder set(CedarTagValue ... set) {
            this.set(Arrays.asList(set));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder set(Consumer<Builder> ... set) {
            this.set(Stream.of(set).map(c -> (CedarTagValue)((Builder)CedarTagValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Builder> getRecord() {
            Map<String, Builder> result = CedarTagRecordAttributeCopier.copyToBuilder(this.record);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRecord(Map<String, BuilderImpl> record) {
            Map<String, CedarTagValue> oldValue = this.record;
            this.record = CedarTagRecordAttributeCopier.copyFromBuilder(record);
            this.handleUnionValueChange(Type.RECORD, oldValue, this.record);
        }

        @Override
        public final Builder record(Map<String, CedarTagValue> record) {
            Map<String, CedarTagValue> oldValue = this.record;
            this.record = CedarTagRecordAttributeCopier.copy(record);
            this.handleUnionValueChange(Type.RECORD, oldValue, this.record);
            return this;
        }

        public final String getIpaddr() {
            return this.ipaddr;
        }

        public final void setIpaddr(String ipaddr) {
            String oldValue = this.ipaddr;
            this.ipaddr = ipaddr;
            this.handleUnionValueChange(Type.IPADDR, oldValue, this.ipaddr);
        }

        @Override
        public final Builder ipaddr(String ipaddr) {
            String oldValue = this.ipaddr;
            this.ipaddr = ipaddr;
            this.handleUnionValueChange(Type.IPADDR, oldValue, this.ipaddr);
            return this;
        }

        public final String getDecimal() {
            return this.decimal;
        }

        public final void setDecimal(String decimal) {
            String oldValue = this.decimal;
            this.decimal = decimal;
            this.handleUnionValueChange(Type.DECIMAL, oldValue, this.decimal);
        }

        @Override
        public final Builder decimal(String decimal) {
            String oldValue = this.decimal;
            this.decimal = decimal;
            this.handleUnionValueChange(Type.DECIMAL, oldValue, this.decimal);
            return this;
        }

        public final String getDatetime() {
            return this.datetime;
        }

        public final void setDatetime(String datetime) {
            String oldValue = this.datetime;
            this.datetime = datetime;
            this.handleUnionValueChange(Type.DATETIME, oldValue, this.datetime);
        }

        @Override
        public final Builder datetime(String datetime) {
            String oldValue = this.datetime;
            this.datetime = datetime;
            this.handleUnionValueChange(Type.DATETIME, oldValue, this.datetime);
            return this;
        }

        public final String getDuration() {
            return this.duration;
        }

        public final void setDuration(String duration) {
            String oldValue = this.duration;
            this.duration = duration;
            this.handleUnionValueChange(Type.DURATION, oldValue, this.duration);
        }

        @Override
        public final Builder duration(String duration) {
            String oldValue = this.duration;
            this.duration = duration;
            this.handleUnionValueChange(Type.DURATION, oldValue, this.duration);
            return this;
        }

        public CedarTagValue build() {
            return new CedarTagValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CedarTagValue> {
        public Builder booleanValue(Boolean var1);

        public Builder entityIdentifier(EntityIdentifier var1);

        default public Builder entityIdentifier(Consumer<EntityIdentifier.Builder> entityIdentifier) {
            return this.entityIdentifier((EntityIdentifier)((EntityIdentifier.Builder)EntityIdentifier.builder().applyMutation(entityIdentifier)).build());
        }

        public Builder longValue(Long var1);

        public Builder string(String var1);

        public Builder set(Collection<CedarTagValue> var1);

        public Builder set(CedarTagValue ... var1);

        public Builder set(Consumer<Builder> ... var1);

        public Builder record(Map<String, CedarTagValue> var1);

        public Builder ipaddr(String var1);

        public Builder decimal(String var1);

        public Builder datetime(String var1);

        public Builder duration(String var1);
    }
}

