/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a policy returned from a <code>BatchGetPolicy</code> API request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetPolicyOutputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetPolicyOutputItem.Builder, BatchGetPolicyOutputItem> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(BatchGetPolicyOutputItem::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyId").getter(getter(BatchGetPolicyOutputItem::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyId").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(BatchGetPolicyOutputItem::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final SdkField<PolicyDefinitionDetail> DEFINITION_FIELD = SdkField
            .<PolicyDefinitionDetail> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(BatchGetPolicyOutputItem::definition)).setter(setter(Builder::definition))
            .constructor(PolicyDefinitionDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate")
            .getter(getter(BatchGetPolicyOutputItem::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate")
            .getter(getter(BatchGetPolicyOutputItem::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            POLICY_ID_FIELD, POLICY_TYPE_FIELD, DEFINITION_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyStoreId;

    private final String policyId;

    private final String policyType;

    private final PolicyDefinitionDetail definition;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private BatchGetPolicyOutputItem(BuilderImpl builder) {
        this.policyStoreId = builder.policyStoreId;
        this.policyId = builder.policyId;
        this.policyType = builder.policyType;
        this.definition = builder.definition;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    /**
     * <p>
     * The identifier of the policy store where the policy you want information about is stored.
     * </p>
     * 
     * @return The identifier of the policy store where the policy you want information about is stored.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * The identifier of the policy you want information about.
     * </p>
     * 
     * @return The identifier of the policy you want information about.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The type of the policy. This is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STATIC</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPLATE_LINKED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of the policy. This is one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STATIC</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPLATE_LINKED</code>
     *         </p>
     *         </li>
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of the policy. This is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>STATIC</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TEMPLATE_LINKED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of the policy. This is one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>STATIC</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TEMPLATE_LINKED</code>
     *         </p>
     *         </li>
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * The policy definition of an item in the list of policies returned.
     * </p>
     * 
     * @return The policy definition of an item in the list of policies returned.
     */
    public final PolicyDefinitionDetail definition() {
        return definition;
    }

    /**
     * <p>
     * The date and time the policy was created.
     * </p>
     * 
     * @return The date and time the policy was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date and time the policy was most recently updated.
     * </p>
     * 
     * @return The date and time the policy was most recently updated.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPolicyOutputItem)) {
            return false;
        }
        BatchGetPolicyOutputItem other = (BatchGetPolicyOutputItem) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && Objects.equals(policyId(), other.policyId())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(definition(), other.definition()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetPolicyOutputItem").add("PolicyStoreId", policyStoreId()).add("PolicyId", policyId())
                .add("PolicyType", policyTypeAsString()).add("Definition", definition()).add("CreatedDate", createdDate())
                .add("LastUpdatedDate", lastUpdatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "policyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("policyId", POLICY_ID_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPolicyOutputItem, T> g) {
        return obj -> g.apply((BatchGetPolicyOutputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetPolicyOutputItem> {
        /**
         * <p>
         * The identifier of the policy store where the policy you want information about is stored.
         * </p>
         * 
         * @param policyStoreId
         *        The identifier of the policy store where the policy you want information about is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * The identifier of the policy you want information about.
         * </p>
         * 
         * @param policyId
         *        The identifier of the policy you want information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The type of the policy. This is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STATIC</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPLATE_LINKED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyType
         *        The type of the policy. This is one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STATIC</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPLATE_LINKED</code>
         *        </p>
         *        </li>
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of the policy. This is one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>STATIC</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TEMPLATE_LINKED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param policyType
         *        The type of the policy. This is one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>STATIC</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TEMPLATE_LINKED</code>
         *        </p>
         *        </li>
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * The policy definition of an item in the list of policies returned.
         * </p>
         * 
         * @param definition
         *        The policy definition of an item in the list of policies returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(PolicyDefinitionDetail definition);

        /**
         * <p>
         * The policy definition of an item in the list of policies returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyDefinitionDetail.Builder} avoiding
         * the need to create one manually via {@link PolicyDefinitionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyDefinitionDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #definition(PolicyDefinitionDetail)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link PolicyDefinitionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(PolicyDefinitionDetail)
         */
        default Builder definition(Consumer<PolicyDefinitionDetail.Builder> definition) {
            return definition(PolicyDefinitionDetail.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The date and time the policy was created.
         * </p>
         * 
         * @param createdDate
         *        The date and time the policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date and time the policy was most recently updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date and time the policy was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);
    }

    static final class BuilderImpl implements Builder {
        private String policyStoreId;

        private String policyId;

        private String policyType;

        private PolicyDefinitionDetail definition;

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPolicyOutputItem model) {
            policyStoreId(model.policyStoreId);
            policyId(model.policyId);
            policyType(model.policyType);
            definition(model.definition);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final PolicyDefinitionDetail.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(PolicyDefinitionDetail.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PolicyDefinitionDetail definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        @Override
        public BatchGetPolicyOutputItem build() {
            return new BatchGetPolicyOutputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
