/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CedarVersion {
    CEDAR_2("CEDAR_2"),
    CEDAR_4("CEDAR_4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CedarVersion> VALUE_MAP;
    private final String value;

    private CedarVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CedarVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CedarVersion> knownValues() {
        EnumSet<CedarVersion> knownValues = EnumSet.allOf(CedarVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CedarVersion.class, CedarVersion::toString);
    }
}

