/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenInputItem;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenInputListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.EntitiesDefinition;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchIsAuthorizedWithTokenRequest
extends VerifiedPermissionsRequest
implements ToCopyableBuilder<Builder, BatchIsAuthorizedWithTokenRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(BatchIsAuthorizedWithTokenRequest.getter(BatchIsAuthorizedWithTokenRequest::policyStoreId)).setter(BatchIsAuthorizedWithTokenRequest.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> IDENTITY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityToken").getter(BatchIsAuthorizedWithTokenRequest.getter(BatchIsAuthorizedWithTokenRequest::identityToken)).setter(BatchIsAuthorizedWithTokenRequest.setter(Builder::identityToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityToken").build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(BatchIsAuthorizedWithTokenRequest.getter(BatchIsAuthorizedWithTokenRequest::accessToken)).setter(BatchIsAuthorizedWithTokenRequest.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<EntitiesDefinition> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("entities").getter(BatchIsAuthorizedWithTokenRequest.getter(BatchIsAuthorizedWithTokenRequest::entities)).setter(BatchIsAuthorizedWithTokenRequest.setter(Builder::entities)).constructor(EntitiesDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build()}).build();
    private static final SdkField<List<BatchIsAuthorizedWithTokenInputItem>> REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requests").getter(BatchIsAuthorizedWithTokenRequest.getter(BatchIsAuthorizedWithTokenRequest::requests)).setter(BatchIsAuthorizedWithTokenRequest.setter(Builder::requests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchIsAuthorizedWithTokenInputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, IDENTITY_TOKEN_FIELD, ACCESS_TOKEN_FIELD, ENTITIES_FIELD, REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchIsAuthorizedWithTokenRequest.memberNameToFieldInitializer();
    private final String policyStoreId;
    private final String identityToken;
    private final String accessToken;
    private final EntitiesDefinition entities;
    private final List<BatchIsAuthorizedWithTokenInputItem> requests;

    private BatchIsAuthorizedWithTokenRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.identityToken = builder.identityToken;
        this.accessToken = builder.accessToken;
        this.entities = builder.entities;
        this.requests = builder.requests;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String identityToken() {
        return this.identityToken;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final EntitiesDefinition entities() {
        return this.entities;
    }

    public final boolean hasRequests() {
        return this.requests != null && !(this.requests instanceof SdkAutoConstructList);
    }

    public final List<BatchIsAuthorizedWithTokenInputItem> requests() {
        return this.requests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequests() ? this.requests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchIsAuthorizedWithTokenRequest)) {
            return false;
        }
        BatchIsAuthorizedWithTokenRequest other = (BatchIsAuthorizedWithTokenRequest)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.identityToken(), other.identityToken()) && Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.entities(), other.entities()) && this.hasRequests() == other.hasRequests() && Objects.equals(this.requests(), other.requests());
    }

    public final String toString() {
        return ToString.builder((String)"BatchIsAuthorizedWithTokenRequest").add("PolicyStoreId", (Object)this.policyStoreId()).add("IdentityToken", (Object)(this.identityToken() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Entities", (Object)this.entities()).add("Requests", this.hasRequests() ? this.requests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "identityToken": {
                return Optional.ofNullable(clazz.cast(this.identityToken()));
            }
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
            case "requests": {
                return Optional.ofNullable(clazz.cast(this.requests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("identityToken", IDENTITY_TOKEN_FIELD);
        map.put("accessToken", ACCESS_TOKEN_FIELD);
        map.put("entities", ENTITIES_FIELD);
        map.put("requests", REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchIsAuthorizedWithTokenRequest, T> g) {
        return obj -> g.apply((BatchIsAuthorizedWithTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsRequest.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private String identityToken;
        private String accessToken;
        private EntitiesDefinition entities;
        private List<BatchIsAuthorizedWithTokenInputItem> requests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchIsAuthorizedWithTokenRequest model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.identityToken(model.identityToken);
            this.accessToken(model.accessToken);
            this.entities(model.entities);
            this.requests(model.requests);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getIdentityToken() {
            return this.identityToken;
        }

        public final void setIdentityToken(String identityToken) {
            this.identityToken = identityToken;
        }

        @Override
        public final Builder identityToken(String identityToken) {
            this.identityToken = identityToken;
            return this;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final EntitiesDefinition.Builder getEntities() {
            return this.entities != null ? this.entities.toBuilder() : null;
        }

        public final void setEntities(EntitiesDefinition.BuilderImpl entities) {
            this.entities = entities != null ? entities.build() : null;
        }

        @Override
        public final Builder entities(EntitiesDefinition entities) {
            this.entities = entities;
            return this;
        }

        public final List<BatchIsAuthorizedWithTokenInputItem.Builder> getRequests() {
            List<BatchIsAuthorizedWithTokenInputItem.Builder> result = BatchIsAuthorizedWithTokenInputListCopier.copyToBuilder(this.requests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequests(Collection<BatchIsAuthorizedWithTokenInputItem.BuilderImpl> requests) {
            this.requests = BatchIsAuthorizedWithTokenInputListCopier.copyFromBuilder(requests);
        }

        @Override
        public final Builder requests(Collection<BatchIsAuthorizedWithTokenInputItem> requests) {
            this.requests = BatchIsAuthorizedWithTokenInputListCopier.copy(requests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(BatchIsAuthorizedWithTokenInputItem ... requests) {
            this.requests(Arrays.asList(requests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requests(Consumer<BatchIsAuthorizedWithTokenInputItem.Builder> ... requests) {
            this.requests(Stream.of(requests).map(c -> (BatchIsAuthorizedWithTokenInputItem)((BatchIsAuthorizedWithTokenInputItem.Builder)BatchIsAuthorizedWithTokenInputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchIsAuthorizedWithTokenRequest build() {
            return new BatchIsAuthorizedWithTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VerifiedPermissionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchIsAuthorizedWithTokenRequest> {
        public Builder policyStoreId(String var1);

        public Builder identityToken(String var1);

        public Builder accessToken(String var1);

        public Builder entities(EntitiesDefinition var1);

        default public Builder entities(Consumer<EntitiesDefinition.Builder> entities) {
            return this.entities((EntitiesDefinition)((EntitiesDefinition.Builder)EntitiesDefinition.builder().applyMutation(entities)).build());
        }

        public Builder requests(Collection<BatchIsAuthorizedWithTokenInputItem> var1);

        public Builder requests(BatchIsAuthorizedWithTokenInputItem ... var1);

        public Builder requests(Consumer<BatchIsAuthorizedWithTokenInputItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

