/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.UpdateConfiguration;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIdentitySourceRequest
extends VerifiedPermissionsRequest
implements ToCopyableBuilder<Builder, UpdateIdentitySourceRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(UpdateIdentitySourceRequest.getter(UpdateIdentitySourceRequest::policyStoreId)).setter(UpdateIdentitySourceRequest.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> IDENTITY_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identitySourceId").getter(UpdateIdentitySourceRequest.getter(UpdateIdentitySourceRequest::identitySourceId)).setter(UpdateIdentitySourceRequest.setter(Builder::identitySourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySourceId").build()}).build();
    private static final SdkField<UpdateConfiguration> UPDATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("updateConfiguration").getter(UpdateIdentitySourceRequest.getter(UpdateIdentitySourceRequest::updateConfiguration)).setter(UpdateIdentitySourceRequest.setter(Builder::updateConfiguration)).constructor(UpdateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateConfiguration").build()}).build();
    private static final SdkField<String> PRINCIPAL_ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalEntityType").getter(UpdateIdentitySourceRequest.getter(UpdateIdentitySourceRequest::principalEntityType)).setter(UpdateIdentitySourceRequest.setter(Builder::principalEntityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalEntityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, IDENTITY_SOURCE_ID_FIELD, UPDATE_CONFIGURATION_FIELD, PRINCIPAL_ENTITY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIdentitySourceRequest.memberNameToFieldInitializer();
    private final String policyStoreId;
    private final String identitySourceId;
    private final UpdateConfiguration updateConfiguration;
    private final String principalEntityType;

    private UpdateIdentitySourceRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.identitySourceId = builder.identitySourceId;
        this.updateConfiguration = builder.updateConfiguration;
        this.principalEntityType = builder.principalEntityType;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String identitySourceId() {
        return this.identitySourceId;
    }

    public final UpdateConfiguration updateConfiguration() {
        return this.updateConfiguration;
    }

    public final String principalEntityType() {
        return this.principalEntityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identitySourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalEntityType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentitySourceRequest)) {
            return false;
        }
        UpdateIdentitySourceRequest other = (UpdateIdentitySourceRequest)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.identitySourceId(), other.identitySourceId()) && Objects.equals(this.updateConfiguration(), other.updateConfiguration()) && Objects.equals(this.principalEntityType(), other.principalEntityType());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIdentitySourceRequest").add("PolicyStoreId", (Object)this.policyStoreId()).add("IdentitySourceId", (Object)this.identitySourceId()).add("UpdateConfiguration", (Object)this.updateConfiguration()).add("PrincipalEntityType", (Object)(this.principalEntityType() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "identitySourceId": {
                return Optional.ofNullable(clazz.cast(this.identitySourceId()));
            }
            case "updateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.updateConfiguration()));
            }
            case "principalEntityType": {
                return Optional.ofNullable(clazz.cast(this.principalEntityType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("identitySourceId", IDENTITY_SOURCE_ID_FIELD);
        map.put("updateConfiguration", UPDATE_CONFIGURATION_FIELD);
        map.put("principalEntityType", PRINCIPAL_ENTITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentitySourceRequest, T> g) {
        return obj -> g.apply((UpdateIdentitySourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsRequest.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private String identitySourceId;
        private UpdateConfiguration updateConfiguration;
        private String principalEntityType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentitySourceRequest model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.identitySourceId(model.identitySourceId);
            this.updateConfiguration(model.updateConfiguration);
            this.principalEntityType(model.principalEntityType);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getIdentitySourceId() {
            return this.identitySourceId;
        }

        public final void setIdentitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
        }

        @Override
        public final Builder identitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
            return this;
        }

        public final UpdateConfiguration.Builder getUpdateConfiguration() {
            return this.updateConfiguration != null ? this.updateConfiguration.toBuilder() : null;
        }

        public final void setUpdateConfiguration(UpdateConfiguration.BuilderImpl updateConfiguration) {
            this.updateConfiguration = updateConfiguration != null ? updateConfiguration.build() : null;
        }

        @Override
        public final Builder updateConfiguration(UpdateConfiguration updateConfiguration) {
            this.updateConfiguration = updateConfiguration;
            return this;
        }

        public final String getPrincipalEntityType() {
            return this.principalEntityType;
        }

        public final void setPrincipalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
        }

        @Override
        public final Builder principalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentitySourceRequest build() {
            return new UpdateIdentitySourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VerifiedPermissionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIdentitySourceRequest> {
        public Builder policyStoreId(String var1);

        public Builder identitySourceId(String var1);

        public Builder updateConfiguration(UpdateConfiguration var1);

        default public Builder updateConfiguration(Consumer<UpdateConfiguration.Builder> updateConfiguration) {
            return this.updateConfiguration((UpdateConfiguration)((UpdateConfiguration.Builder)UpdateConfiguration.builder().applyMutation(updateConfiguration)).build());
        }

        public Builder principalEntityType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

