/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyEffect {
    PERMIT("Permit"),
    FORBID("Forbid"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyEffect> VALUE_MAP;
    private final String value;

    private PolicyEffect(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyEffect fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyEffect> knownValues() {
        EnumSet<PolicyEffect> knownValues = EnumSet.allOf(PolicyEffect.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyEffect.class, PolicyEffect::toString);
    }
}

