/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyTemplateItem;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyTemplatesListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyTemplatesResponse
extends VerifiedPermissionsResponse
implements ToCopyableBuilder<Builder, ListPolicyTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPolicyTemplatesResponse.getter(ListPolicyTemplatesResponse::nextToken)).setter(ListPolicyTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PolicyTemplateItem>> POLICY_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyTemplates").getter(ListPolicyTemplatesResponse.getter(ListPolicyTemplatesResponse::policyTemplates)).setter(ListPolicyTemplatesResponse.setter(Builder::policyTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyTemplateItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, POLICY_TEMPLATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPolicyTemplatesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<PolicyTemplateItem> policyTemplates;

    private ListPolicyTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.policyTemplates = builder.policyTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPolicyTemplates() {
        return this.policyTemplates != null && !(this.policyTemplates instanceof SdkAutoConstructList);
    }

    public final List<PolicyTemplateItem> policyTemplates() {
        return this.policyTemplates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyTemplates() ? this.policyTemplates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyTemplatesResponse)) {
            return false;
        }
        ListPolicyTemplatesResponse other = (ListPolicyTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPolicyTemplates() == other.hasPolicyTemplates() && Objects.equals(this.policyTemplates(), other.policyTemplates());
    }

    public final String toString() {
        return ToString.builder((String)"ListPolicyTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("PolicyTemplates", this.hasPolicyTemplates() ? this.policyTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "policyTemplates": {
                return Optional.ofNullable(clazz.cast(this.policyTemplates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("policyTemplates", POLICY_TEMPLATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyTemplatesResponse, T> g) {
        return obj -> g.apply((ListPolicyTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PolicyTemplateItem> policyTemplates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.policyTemplates(model.policyTemplates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PolicyTemplateItem.Builder> getPolicyTemplates() {
            List<PolicyTemplateItem.Builder> result = PolicyTemplatesListCopier.copyToBuilder(this.policyTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyTemplates(Collection<PolicyTemplateItem.BuilderImpl> policyTemplates) {
            this.policyTemplates = PolicyTemplatesListCopier.copyFromBuilder(policyTemplates);
        }

        @Override
        public final Builder policyTemplates(Collection<PolicyTemplateItem> policyTemplates) {
            this.policyTemplates = PolicyTemplatesListCopier.copy(policyTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTemplates(PolicyTemplateItem ... policyTemplates) {
            this.policyTemplates(Arrays.asList(policyTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTemplates(Consumer<PolicyTemplateItem.Builder> ... policyTemplates) {
            this.policyTemplates(Stream.of(policyTemplates).map(c -> (PolicyTemplateItem)((PolicyTemplateItem.Builder)PolicyTemplateItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPolicyTemplatesResponse build() {
            return new ListPolicyTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder policyTemplates(Collection<PolicyTemplateItem> var1);

        public Builder policyTemplates(PolicyTemplateItem ... var1);

        public Builder policyTemplates(Consumer<PolicyTemplateItem.Builder> ... var1);
    }
}

