/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenOutputItem;
import software.amazon.awssdk.services.verifiedpermissions.model.BatchIsAuthorizedWithTokenOutputListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityIdentifier;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchIsAuthorizedWithTokenResponse
extends VerifiedPermissionsResponse
implements ToCopyableBuilder<Builder, BatchIsAuthorizedWithTokenResponse> {
    private static final SdkField<EntityIdentifier> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("principal").getter(BatchIsAuthorizedWithTokenResponse.getter(BatchIsAuthorizedWithTokenResponse::principal)).setter(BatchIsAuthorizedWithTokenResponse.setter(Builder::principal)).constructor(EntityIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<List<BatchIsAuthorizedWithTokenOutputItem>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("results").getter(BatchIsAuthorizedWithTokenResponse.getter(BatchIsAuthorizedWithTokenResponse::results)).setter(BatchIsAuthorizedWithTokenResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchIsAuthorizedWithTokenOutputItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD, RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchIsAuthorizedWithTokenResponse.memberNameToFieldInitializer();
    private final EntityIdentifier principal;
    private final List<BatchIsAuthorizedWithTokenOutputItem> results;

    private BatchIsAuthorizedWithTokenResponse(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.results = builder.results;
    }

    public final EntityIdentifier principal() {
        return this.principal;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<BatchIsAuthorizedWithTokenOutputItem> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchIsAuthorizedWithTokenResponse)) {
            return false;
        }
        BatchIsAuthorizedWithTokenResponse other = (BatchIsAuthorizedWithTokenResponse)((Object)obj);
        return Objects.equals(this.principal(), other.principal()) && this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results());
    }

    public final String toString() {
        return ToString.builder((String)"BatchIsAuthorizedWithTokenResponse").add("Principal", (Object)this.principal()).add("Results", this.hasResults() ? this.results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("principal", PRINCIPAL_FIELD);
        map.put("results", RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchIsAuthorizedWithTokenResponse, T> g) {
        return obj -> g.apply((BatchIsAuthorizedWithTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsResponse.BuilderImpl
    implements Builder {
        private EntityIdentifier principal;
        private List<BatchIsAuthorizedWithTokenOutputItem> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchIsAuthorizedWithTokenResponse model) {
            super(model);
            this.principal(model.principal);
            this.results(model.results);
        }

        public final EntityIdentifier.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(EntityIdentifier.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(EntityIdentifier principal) {
            this.principal = principal;
            return this;
        }

        public final List<BatchIsAuthorizedWithTokenOutputItem.Builder> getResults() {
            List<BatchIsAuthorizedWithTokenOutputItem.Builder> result = BatchIsAuthorizedWithTokenOutputListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<BatchIsAuthorizedWithTokenOutputItem.BuilderImpl> results) {
            this.results = BatchIsAuthorizedWithTokenOutputListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<BatchIsAuthorizedWithTokenOutputItem> results) {
            this.results = BatchIsAuthorizedWithTokenOutputListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(BatchIsAuthorizedWithTokenOutputItem ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<BatchIsAuthorizedWithTokenOutputItem.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (BatchIsAuthorizedWithTokenOutputItem)((BatchIsAuthorizedWithTokenOutputItem.Builder)BatchIsAuthorizedWithTokenOutputItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchIsAuthorizedWithTokenResponse build() {
            return new BatchIsAuthorizedWithTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchIsAuthorizedWithTokenResponse> {
        public Builder principal(EntityIdentifier var1);

        default public Builder principal(Consumer<EntityIdentifier.Builder> principal) {
            return this.principal((EntityIdentifier)((EntityIdentifier.Builder)EntityIdentifier.builder().applyMutation(principal)).build());
        }

        public Builder results(Collection<BatchIsAuthorizedWithTokenOutputItem> var1);

        public Builder results(BatchIsAuthorizedWithTokenOutputItem ... var1);

        public Builder results(Consumer<BatchIsAuthorizedWithTokenOutputItem.Builder> ... var1);
    }
}

