/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.verifiedpermissions.model.ActionIdentifier;
import software.amazon.awssdk.services.verifiedpermissions.model.ActionIdentifierListCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityIdentifier;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyEffect;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyType;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePolicyResponse
extends VerifiedPermissionsResponse
implements ToCopyableBuilder<Builder, CreatePolicyResponse> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(CreatePolicyResponse.getter(CreatePolicyResponse::policyStoreId)).setter(CreatePolicyResponse.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyId").getter(CreatePolicyResponse.getter(CreatePolicyResponse::policyId)).setter(CreatePolicyResponse.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyId").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(CreatePolicyResponse.getter(CreatePolicyResponse::policyTypeAsString)).setter(CreatePolicyResponse.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final SdkField<EntityIdentifier> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("principal").getter(CreatePolicyResponse.getter(CreatePolicyResponse::principal)).setter(CreatePolicyResponse.setter(Builder::principal)).constructor(EntityIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<EntityIdentifier> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(CreatePolicyResponse.getter(CreatePolicyResponse::resource)).setter(CreatePolicyResponse.setter(Builder::resource)).constructor(EntityIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<List<ActionIdentifier>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(CreatePolicyResponse.getter(CreatePolicyResponse::actions)).setter(CreatePolicyResponse.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(CreatePolicyResponse.getter(CreatePolicyResponse::createdDate)).setter(CreatePolicyResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(CreatePolicyResponse.getter(CreatePolicyResponse::lastUpdatedDate)).setter(CreatePolicyResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("effect").getter(CreatePolicyResponse.getter(CreatePolicyResponse::effectAsString)).setter(CreatePolicyResponse.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effect").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, POLICY_ID_FIELD, POLICY_TYPE_FIELD, PRINCIPAL_FIELD, RESOURCE_FIELD, ACTIONS_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, EFFECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePolicyResponse.memberNameToFieldInitializer();
    private final String policyStoreId;
    private final String policyId;
    private final String policyType;
    private final EntityIdentifier principal;
    private final EntityIdentifier resource;
    private final List<ActionIdentifier> actions;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;
    private final String effect;

    private CreatePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.policyId = builder.policyId;
        this.policyType = builder.policyType;
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.actions = builder.actions;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.effect = builder.effect;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final EntityIdentifier principal() {
        return this.principal;
    }

    public final EntityIdentifier resource() {
        return this.resource;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<ActionIdentifier> actions() {
        return this.actions;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final PolicyEffect effect() {
        return PolicyEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyResponse)) {
            return false;
        }
        CreatePolicyResponse other = (CreatePolicyResponse)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.resource(), other.resource()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.effectAsString(), other.effectAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePolicyResponse").add("PolicyStoreId", (Object)this.policyStoreId()).add("PolicyId", (Object)this.policyId()).add("PolicyType", (Object)this.policyTypeAsString()).add("Principal", (Object)this.principal()).add("Resource", (Object)this.resource()).add("Actions", this.hasActions() ? this.actions() : null).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("Effect", (Object)this.effectAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "policyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyStoreId", POLICY_STORE_ID_FIELD);
        map.put("policyId", POLICY_ID_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("effect", EFFECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyResponse, T> g) {
        return obj -> g.apply((CreatePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsResponse.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private String policyId;
        private String policyType;
        private EntityIdentifier principal;
        private EntityIdentifier resource;
        private List<ActionIdentifier> actions = DefaultSdkAutoConstructList.getInstance();
        private Instant createdDate;
        private Instant lastUpdatedDate;
        private String effect;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyResponse model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.policyId(model.policyId);
            this.policyType(model.policyType);
            this.principal(model.principal);
            this.resource(model.resource);
            this.actions(model.actions);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.effect(model.effect);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final EntityIdentifier.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(EntityIdentifier.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(EntityIdentifier principal) {
            this.principal = principal;
            return this;
        }

        public final EntityIdentifier.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(EntityIdentifier.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(EntityIdentifier resource) {
            this.resource = resource;
            return this;
        }

        public final List<ActionIdentifier.Builder> getActions() {
            List<ActionIdentifier.Builder> result = ActionIdentifierListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ActionIdentifier.BuilderImpl> actions) {
            this.actions = ActionIdentifierListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ActionIdentifier> actions) {
            this.actions = ActionIdentifierListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ActionIdentifier ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ActionIdentifier.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (ActionIdentifier)((ActionIdentifier.Builder)ActionIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(PolicyEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        @Override
        public CreatePolicyResponse build() {
            return new CreatePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePolicyResponse> {
        public Builder policyStoreId(String var1);

        public Builder policyId(String var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder principal(EntityIdentifier var1);

        default public Builder principal(Consumer<EntityIdentifier.Builder> principal) {
            return this.principal((EntityIdentifier)((EntityIdentifier.Builder)EntityIdentifier.builder().applyMutation(principal)).build());
        }

        public Builder resource(EntityIdentifier var1);

        default public Builder resource(Consumer<EntityIdentifier.Builder> resource) {
            return this.resource((EntityIdentifier)((EntityIdentifier.Builder)EntityIdentifier.builder().applyMutation(resource)).build());
        }

        public Builder actions(Collection<ActionIdentifier> var1);

        public Builder actions(ActionIdentifier ... var1);

        public Builder actions(Consumer<ActionIdentifier.Builder> ... var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder effect(String var1);

        public Builder effect(PolicyEffect var1);
    }
}

