/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a static policy.
 * </p>
 * <p>
 * This data type is used as a field that is part of the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_PolicyDefinitionDetail.html"
 * >PolicyDefinitionDetail</a> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticPolicyDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<StaticPolicyDefinition.Builder, StaticPolicyDefinition> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(StaticPolicyDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statement").getter(getter(StaticPolicyDefinition::statement)).setter(setter(Builder::statement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            STATEMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String statement;

    private StaticPolicyDefinition(BuilderImpl builder) {
        this.description = builder.description;
        this.statement = builder.statement;
    }

    /**
     * <p>
     * The description of the static policy.
     * </p>
     * 
     * @return The description of the static policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The policy content of the static policy, written in the Cedar policy language.
     * </p>
     * 
     * @return The policy content of the static policy, written in the Cedar policy language.
     */
    public final String statement() {
        return statement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticPolicyDefinition)) {
            return false;
        }
        StaticPolicyDefinition other = (StaticPolicyDefinition) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(statement(), other.statement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaticPolicyDefinition")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Statement", statement() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "statement":
            return Optional.ofNullable(clazz.cast(statement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaticPolicyDefinition, T> g) {
        return obj -> g.apply((StaticPolicyDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticPolicyDefinition> {
        /**
         * <p>
         * The description of the static policy.
         * </p>
         * 
         * @param description
         *        The description of the static policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The policy content of the static policy, written in the Cedar policy language.
         * </p>
         * 
         * @param statement
         *        The policy content of the static policy, written in the Cedar policy language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statement(String statement);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String statement;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticPolicyDefinition model) {
            description(model.description);
            statement(model.statement);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatement() {
            return statement;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        @Override
        public StaticPolicyDefinition build() {
            return new StaticPolicyDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
