/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines characteristics of an identity source that you can use to filter.
 * </p>
 * <p>
 * This data type is a request parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_ListIdentityStores.html"
 * >ListIdentityStores</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentitySourceFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentitySourceFilter.Builder, IdentitySourceFilter> {
    private static final SdkField<String> PRINCIPAL_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalEntityType").getter(getter(IdentitySourceFilter::principalEntityType))
            .setter(setter(Builder::principalEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalEntityType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ENTITY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String principalEntityType;

    private IdentitySourceFilter(BuilderImpl builder) {
        this.principalEntityType = builder.principalEntityType;
    }

    /**
     * <p>
     * The Cedar entity type of the principals returned by the identity provider (IdP) associated with this identity
     * source.
     * </p>
     * 
     * @return The Cedar entity type of the principals returned by the identity provider (IdP) associated with this
     *         identity source.
     */
    public final String principalEntityType() {
        return principalEntityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principalEntityType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentitySourceFilter)) {
            return false;
        }
        IdentitySourceFilter other = (IdentitySourceFilter) obj;
        return Objects.equals(principalEntityType(), other.principalEntityType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentitySourceFilter")
                .add("PrincipalEntityType", principalEntityType() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principalEntityType":
            return Optional.ofNullable(clazz.cast(principalEntityType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentitySourceFilter, T> g) {
        return obj -> g.apply((IdentitySourceFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentitySourceFilter> {
        /**
         * <p>
         * The Cedar entity type of the principals returned by the identity provider (IdP) associated with this identity
         * source.
         * </p>
         * 
         * @param principalEntityType
         *        The Cedar entity type of the principals returned by the identity provider (IdP) associated with this
         *        identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalEntityType(String principalEntityType);
    }

    static final class BuilderImpl implements Builder {
        private String principalEntityType;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentitySourceFilter model) {
            principalEntityType(model.principalEntityType);
        }

        public final String getPrincipalEntityType() {
            return principalEntityType;
        }

        public final void setPrincipalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
        }

        @Override
        public final Builder principalEntityType(String principalEntityType) {
            this.principalEntityType = principalEntityType;
            return this;
        }

        @Override
        public IdentitySourceFilter build() {
            return new IdentitySourceFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
