/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsBaseClientBuilder;
import software.amazon.awssdk.services.verifiedpermissions.endpoints.VerifiedPermissionsEndpointProvider;
import software.amazon.awssdk.services.verifiedpermissions.endpoints.internal.VerifiedPermissionsRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.verifiedpermissions.endpoints.internal.VerifiedPermissionsResolveEndpointInterceptor;
import software.amazon.awssdk.services.verifiedpermissions.internal.SdkClientConfigurationUtil;
import software.amazon.awssdk.services.verifiedpermissions.internal.VerifiedPermissionsServiceClientConfigurationBuilder;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
abstract class DefaultVerifiedPermissionsBaseClientBuilder<B extends VerifiedPermissionsBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultVerifiedPermissionsBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "verifiedpermissions";
    }

    protected final String serviceName() {
        return "VerifiedPermissions";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new VerifiedPermissionsResolveEndpointInterceptor());
        endpointInterceptors.add(new VerifiedPermissionsRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/verifiedpermissions/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        SdkClientConfiguration.Builder builder = config.toBuilder();
        builder.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors);
        return builder.build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "verifiedpermissions";
    }

    private VerifiedPermissionsEndpointProvider defaultEndpointProvider() {
        return VerifiedPermissionsEndpointProvider.defaultProvider();
    }

    protected SdkClientConfiguration setOverrides(SdkClientConfiguration configuration) {
        ClientOverrideConfiguration overrideConfiguration = this.overrideConfiguration();
        if (overrideConfiguration == null) {
            return configuration;
        }
        return SdkClientConfigurationUtil.copyOverridesToConfiguration(overrideConfiguration, configuration.toBuilder()).build();
    }

    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List<SdkPlugin> internalPlugins = this.internalPlugins();
        List externalPlugins = this.plugins();
        if (internalPlugins.isEmpty() && externalPlugins.isEmpty()) {
            return config;
        }
        List plugins = CollectionUtils.mergeLists(internalPlugins, (List)externalPlugins);
        VerifiedPermissionsServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = VerifiedPermissionsServiceClientConfigurationBuilder.builder(config.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.overrideConfiguration(serviceConfigBuilder.overrideConfiguration());
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private List<SdkPlugin> internalPlugins() {
        ArrayList<SdkPlugin> internalPlugins = new ArrayList<SdkPlugin>();
        return internalPlugins;
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
        Validate.notNull((Object)((Signer)c.option((ClientOption)SdkAdvancedClientOption.SIGNER)), (String)"The 'overrideConfiguration.advancedOption[SIGNER]' must be configured in the client builder.", (Object[])new Object[0]);
    }
}

