/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.verifiedpermissions.VerifiedPermissionsClient;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyTemplatesRequest;
import software.amazon.awssdk.services.verifiedpermissions.model.ListPolicyTemplatesResponse;
import software.amazon.awssdk.services.verifiedpermissions.model.PolicyTemplateItem;

public class ListPolicyTemplatesIterable
implements SdkIterable<ListPolicyTemplatesResponse> {
    private final VerifiedPermissionsClient client;
    private final ListPolicyTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyTemplatesIterable(VerifiedPermissionsClient client, ListPolicyTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPolicyTemplatesResponseFetcher();
    }

    public Iterator<ListPolicyTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyTemplateItem> policyTemplates() {
        Function<ListPolicyTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyTemplates() != null) {
                return response.policyTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyTemplatesResponseFetcher
    implements SyncPageFetcher<ListPolicyTemplatesResponse> {
        private ListPolicyTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPolicyTemplatesResponse nextPage(ListPolicyTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyTemplatesIterable.this.client.listPolicyTemplates(ListPolicyTemplatesIterable.this.firstRequest);
            }
            return ListPolicyTemplatesIterable.this.client.listPolicyTemplates((ListPolicyTemplatesRequest)((Object)ListPolicyTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

