/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class S3PutObjectRequestToV2
extends Recipe {
    private static final MethodMatcher PUT_OBJ_WITH_REQUEST = S3TransformUtils.v2S3MethodMatcher(String.format("putObject(%sPutObjectRequest)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher UPLOAD_WITH_REQUEST = S3TransformUtils.v2TmMethodMatcher(String.format("upload(%sPutObjectRequest)", "software.amazon.awssdk.services.s3.model."));

    public String getDisplayName() {
        return "V1 S3 PutObjectRequest, AmazonS3.putObject(PutObjectRequest), and TransferManager.upload(PutObjectRequest) to V2";
    }

    public String getDescription() {
        return "Transform V1 S3 PutObjectRequest to V2, as well as methods that take it as an argument.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Queue<Expression> filesQueue = new ArrayDeque<Expression>();

        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (this.isPutObjectRequestBuilderSetter(method)) {
                if (this.isPayloadSetter(method)) {
                    return this.transformRequestBuilderPayloadSetter(method, executionContext);
                }
                if (this.isRequestPayerSetter(method)) {
                    return this.transformRequesterPaysSetter(method);
                }
            }
            if (this.isPutObjectRequestSetter(method) && this.isPayloadSetter(method)) {
                return this.transformRequestPayloadSetter(method, executionContext);
            }
            if (PUT_OBJ_WITH_REQUEST.matches((MethodCall)method)) {
                method = super.visitMethodInvocation(method, (Object)executionContext);
                method = this.transformPutObjectWithRequest(method, executionContext);
                return method;
            }
            if (UPLOAD_WITH_REQUEST.matches((MethodCall)method)) {
                method = super.visitMethodInvocation(method, (Object)executionContext);
                method = this.transformUploadWithRequest(method, executionContext);
                return method;
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }

        private J.MethodInvocation transformRequestBuilderPayloadSetter(J.MethodInvocation method, ExecutionContext executionContext) {
            Expression payload = (Expression)method.getArguments().get(0);
            String variableName = this.retrieveVariableNameIfRequestPojoIsAssigned();
            if (variableName != null) {
                executionContext.putMessage(variableName, (Object)payload);
            } else {
                this.filesQueue.add(payload);
            }
            return (J.MethodInvocation)method.getSelect();
        }

        private J.MethodInvocation transformRequestPayloadSetter(J.MethodInvocation method, ExecutionContext executionContext) {
            J.Identifier requestPojo = (J.Identifier)method.getSelect();
            String variableName = requestPojo.getSimpleName();
            Expression payload = (Expression)method.getArguments().get(0);
            executionContext.putMessage(variableName, (Object)payload);
            return null;
        }

        private String retrieveVariableNameIfRequestPojoIsAssigned() {
            J parent = (J)this.getCursor().dropParentUntil(p -> p instanceof J.VariableDeclarations.NamedVariable || p instanceof J.Block).getValue();
            if (parent instanceof J.VariableDeclarations.NamedVariable) {
                J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)parent;
                return namedVariable.getSimpleName();
            }
            return null;
        }

        private J.MethodInvocation transformPutObjectWithRequest(J.MethodInvocation method, ExecutionContext executionContext) {
            Expression payload = this.retrieveRequestPayload(method, executionContext);
            if (payload == null) {
                method = this.addEmptyRequestBodyToPutObject(method);
            } else if (SdkTypeUtils.isFileType(payload.getType())) {
                method = this.addFileToPutObject(method, payload);
            } else if (SdkTypeUtils.isInputStreamType(payload.getType())) {
                method = this.addInputStreamToPutObject(method, payload);
            }
            this.addRequestBodyImport();
            return method;
        }

        private Expression retrieveRequestPayload(J.MethodInvocation method, ExecutionContext executionContext) {
            Expression payload;
            Expression requestPojo = (Expression)method.getArguments().get(0);
            if (requestPojo instanceof J.Identifier) {
                J.Identifier pojo = (J.Identifier)requestPojo;
                payload = (Expression)executionContext.pollMessage(pojo.getSimpleName());
            } else {
                payload = this.filesQueue.poll();
            }
            return payload;
        }

        private J.MethodInvocation transformUploadWithRequest(J.MethodInvocation method, ExecutionContext executionContext) {
            Expression payload = this.retrieveRequestPayload(method, executionContext);
            if (payload == null) {
                method = this.addEmptyAsyncRequestBodyToUpload(method);
            } else if (SdkTypeUtils.isFileType(payload.getType())) {
                method = this.addFileAndChangeMethodToUploadFile(method, payload);
            } else if (SdkTypeUtils.isInputStreamType(payload.getType())) {
                method = this.addInputStreamToUpload(method, payload);
            }
            return method;
        }

        private J.MethodInvocation addEmptyAsyncRequestBodyToUpload(J.MethodInvocation method) {
            String v2Method = "UploadRequest.builder().putObjectRequest(#{any()}).requestBody(AsyncRequestBody.empty()).build()";
            this.addTmImport("UploadRequest");
            this.addAsyncRequestBodyImport();
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0)});
        }

        private J.MethodInvocation addEmptyRequestBodyToPutObject(J.MethodInvocation method) {
            String v2Method = "#{any()}, RequestBody.empty()";
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0)});
        }

        private J.MethodInvocation addFileAndChangeMethodToUploadFile(J.MethodInvocation method, Expression file) {
            String v2Method = "#{any()}.uploadFile(UploadFileRequest.builder().putObjectRequest(#{any()}).source(#{any()}).build())";
            this.addTmImport("UploadFileRequest");
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), file});
        }

        private J.MethodInvocation addInputStreamToUpload(J.MethodInvocation method, Expression inputStream) {
            long contentLength = this.extractContentLengthIfSet(method);
            String v2Method = String.format("UploadRequest.builder().putObjectRequest(#{any()}).requestBody(AsyncRequestBody.fromInputStream(#{any()}, %dL, newExecutorServiceVariableToDefine)).build()", contentLength);
            this.addTmImport("UploadRequest");
            this.addAsyncRequestBodyImport();
            String comment = "When using InputStream to upload with TransferManager, you must specify Content-Length and ExecutorService.";
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0), inputStream}).withComments(this.createComments(comment));
        }

        private J.MethodInvocation addFileToPutObject(J.MethodInvocation method, Expression file) {
            String v2Method = "#{any()}, RequestBody.fromFile(#{any()})";
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0), file});
        }

        private J.MethodInvocation addInputStreamToPutObject(J.MethodInvocation method, Expression inputStream) {
            long contentLength = this.extractContentLengthIfSet(method);
            if (contentLength < 0L) {
                String comment = "When using InputStream to upload with S3Client, Content-Length should be specified and used with RequestBody.fromInputStream(). Otherwise, the entire stream will be buffered in memory.";
                String v2Method = "#{any()}, RequestBody.fromContentProvider(() -> #{any()}, \"binary/octet-stream\")";
                return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0), inputStream}).withComments(this.createComments(comment));
            }
            String v2Method = String.format("#{any()}, RequestBody.fromInputStream(#{any()}, %d)", contentLength);
            return (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{method.getArguments().get(0), inputStream});
        }

        private long extractContentLengthIfSet(J.MethodInvocation method) {
            return -1L;
        }

        private J.MethodInvocation transformRequesterPaysSetter(J.MethodInvocation method) {
            Expression expression = (Expression)method.getArguments().get(0);
            if (expression instanceof J.Literal) {
                J.Literal literal = (J.Literal)expression;
                if (Boolean.TRUE.equals(literal.getValue())) {
                    this.addS3Import("RequestPayer");
                } else {
                    return (J.MethodInvocation)method.getSelect();
                }
            }
            return (J.MethodInvocation)JavaTemplate.builder((String)"RequestPayer.REQUESTER").build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[0]);
        }

        private List<Comment> createComments(String comment) {
            return Collections.singletonList(new TextComment(true, "AWS SDK for Java v2 migration: " + comment, "", Markers.EMPTY));
        }

        private boolean isPutObjectRequestBuilderSetter(J.MethodInvocation method) {
            return this.isSetterForClassType(method, "software.amazon.awssdk.services.s3.model.PutObjectRequest$Builder");
        }

        private boolean isPutObjectRequestSetter(J.MethodInvocation method) {
            return this.isSetterForClassType(method, "software.amazon.awssdk.services.s3.model.PutObjectRequest");
        }

        private boolean isSetterForClassType(J.MethodInvocation method, String fqcn) {
            if (method.getSelect() == null || method.getSelect().getType() == null) {
                return false;
            }
            return TypeUtils.isOfClassType((JavaType)method.getSelect().getType(), (String)fqcn);
        }

        private boolean isPayloadSetter(J.MethodInvocation method) {
            return "file".equals(method.getSimpleName()) || "inputStream".equals(method.getSimpleName());
        }

        private boolean isRequestPayerSetter(J.MethodInvocation method) {
            return "requestPayer".equals(method.getSimpleName());
        }

        private void addRequestBodyImport() {
            String fqcn = "software.amazon.awssdk.core.sync.RequestBody";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addAsyncRequestBodyImport() {
            String fqcn = "software.amazon.awssdk.core.async.AsyncRequestBody";
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addS3Import(String pojoName) {
            String fqcn = "software.amazon.awssdk.services.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addTmImport(String pojoName) {
            String fqcn = "software.amazon.awssdk.transfer.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }
    }
}

