/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration.internal.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class S3TransformUtils {
    public static final String V1_S3_CLIENT = "com.amazonaws.services.s3.AmazonS3";
    public static final String V1_S3_MODEL_PKG = "com.amazonaws.services.s3.model.";
    public static final String V1_S3_PKG = "com.amazonaws.services.s3.";
    public static final String V1_EN_PKG = "com.amazonaws.services.s3.event.";
    public static final String V2_S3_CLIENT = "software.amazon.awssdk.services.s3.S3Client";
    public static final String V2_S3_MODEL_PKG = "software.amazon.awssdk.services.s3.model.";
    public static final String V2_S3_PKG = "software.amazon.awssdk.services.s3.";
    public static final String V2_TM_CLIENT = "software.amazon.awssdk.transfer.s3.S3TransferManager";
    public static final String V2_TM_MODEL_PKG = "software.amazon.awssdk.transfer.s3.model.";
    public static final Set<String> SUPPORTED_METADATA_TRANSFORMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("contentLength", "contentEncoding", "contentType", "contentLanguage", "cacheControl", "contentDisposition", "contentMd5", "sseAlgorithm", "serverSideEncryption", "sseCustomerKeyMd5", "bucketKeyEnabled", "userMetadata", "httpExpiresDate")));
    public static final Set<String> UNSUPPORTED_PUT_OBJ_REQUEST_TRANSFORMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("sseCustomerKey", "sseAwsKeyManagementParams", "accessControlList")));

    private S3TransformUtils() {
    }

    public static MethodMatcher v1S3MethodMatcher(String methodSignature) {
        return new MethodMatcher("com.amazonaws.services.s3.AmazonS3 " + methodSignature, true);
    }

    public static MethodMatcher v1EnMethodMatcher(String methodSignature) {
        return new MethodMatcher(V1_EN_PKG + methodSignature, true);
    }

    public static MethodMatcher v2S3MethodMatcher(String methodSignature) {
        return new MethodMatcher("software.amazon.awssdk.services.s3.S3Client " + methodSignature, true);
    }

    public static MethodMatcher v2TmMethodMatcher(String methodSignature) {
        return new MethodMatcher("software.amazon.awssdk.transfer.s3.S3TransferManager " + methodSignature, true);
    }

    public static void addMetadataFields(StringBuilder sb, String metadataName, Map<String, Map<String, Expression>> metadataMap) {
        Expression expiresDate;
        Expression userMetadata;
        Expression bucketKeyEnabled;
        Expression sseCustomerKeyMd5;
        Expression sseAlgorithm;
        Expression serverSideEncryption;
        Expression contentMd5;
        Expression contentDisposition;
        Expression cacheControl;
        Expression contentLanguage;
        Expression contentType;
        Expression contentEncoding;
        Map<String, Expression> map = metadataMap.get(metadataName);
        if (map == null) {
            return;
        }
        Expression contentLen = map.get("contentLength");
        if (contentLen != null) {
            sb.append(".contentLength(").append(contentLen);
            if (contentLen instanceof J.Literal) {
                sb.append("L");
            }
            sb.append(")\n");
        }
        if ((contentEncoding = map.get("contentEncoding")) != null) {
            sb.append(".contentEncoding(\"").append(contentEncoding).append("\")\n");
        }
        if ((contentType = map.get("contentType")) != null) {
            sb.append(".contentType(\"").append(contentType).append("\")\n");
        }
        if ((contentLanguage = map.get("contentLanguage")) != null) {
            sb.append(".contentLanguage(\"").append(contentLanguage).append("\")\n");
        }
        if ((cacheControl = map.get("cacheControl")) != null) {
            sb.append(".cacheControl(\"").append(cacheControl).append("\")\n");
        }
        if ((contentDisposition = map.get("contentDisposition")) != null) {
            sb.append(".contentDisposition(\"").append(contentDisposition).append("\")\n");
        }
        if ((contentMd5 = map.get("contentMd5")) != null) {
            sb.append(".contentMD5(\"").append(contentMd5).append("\")\n");
        }
        if ((serverSideEncryption = map.get("serverSideEncryption")) != null) {
            sb.append(".serverSideEncryption(\"").append(serverSideEncryption).append("\")\n");
        }
        if ((sseAlgorithm = map.get("sseAlgorithm")) != null) {
            sb.append(".serverSideEncryption(\"").append(sseAlgorithm).append("\")\n");
        }
        if ((sseCustomerKeyMd5 = map.get("sseCustomerKeyMd5")) != null) {
            sb.append(".sseCustomerKeyMD5(\"").append(sseCustomerKeyMd5).append("\")\n");
        }
        if ((bucketKeyEnabled = map.get("bucketKeyEnabled")) != null) {
            sb.append(".bucketKeyEnabled(").append(bucketKeyEnabled).append(")\n");
        }
        if ((userMetadata = map.get("userMetadata")) != null) {
            sb.append(".metadata(").append(userMetadata).append(")\n");
        }
        if ((expiresDate = map.get("httpExpiresDate")) != null) {
            sb.append(".expires(").append(expiresDate).append(")\n");
        }
    }

    public static String changeBucketNameToBucket(String methodName) {
        if (methodName.contains("BucketName")) {
            return methodName.replace("BucketName", "Bucket");
        }
        return methodName;
    }

    public static String getArgumentName(J.MethodInvocation method) {
        Expression val = (Expression)method.getArguments().get(0);
        return ((J.Identifier)val).getSimpleName();
    }

    public static String getSelectName(J.MethodInvocation method) {
        Expression select = method.getSelect();
        return ((J.Identifier)select).getSimpleName();
    }

    private static Comment generateComment(String comment, boolean withNewLine) {
        String suffix = withNewLine ? "\n" : "";
        return new TextComment(true, "AWS SDK for Java v2 migration: " + comment, suffix, Markers.EMPTY);
    }

    public static Comment createComment(String comment) {
        return S3TransformUtils.generateComment(comment, false);
    }

    public static Comment createCommentWithNewline(String comment) {
        return S3TransformUtils.generateComment(comment, true);
    }

    public static List<Comment> createComments(String comment) {
        return Arrays.asList(S3TransformUtils.createComment(comment));
    }

    public static List<Comment> createCommentsWithNewline(String comment) {
        return Arrays.asList(S3TransformUtils.createCommentWithNewline(comment));
    }

    public static boolean isUnsupportedPutObjectRequestSetter(J.MethodInvocation method) {
        return UNSUPPORTED_PUT_OBJ_REQUEST_TRANSFORMS.contains(method.getSimpleName());
    }

    public static boolean isObjectMetadataSetter(J.MethodInvocation method) {
        return S3TransformUtils.isSetterForClassType(method, "software.amazon.awssdk.services.s3.model.HeadObjectResponse");
    }

    public static boolean isPutObjectRequestBuilderSetter(J.MethodInvocation method) {
        return S3TransformUtils.isSetterForClassType(method, "software.amazon.awssdk.services.s3.model.PutObjectRequest$Builder");
    }

    public static boolean isPutObjectRequestSetter(J.MethodInvocation method) {
        return S3TransformUtils.isSetterForClassType(method, "software.amazon.awssdk.services.s3.model.PutObjectRequest");
    }

    public static boolean isS3PutObjectOrObjectMetadata(J.MethodInvocation method) {
        return S3TransformUtils.isObjectMetadataSetter(method) || S3TransformUtils.isPutObjectRequestSetter(method) || S3TransformUtils.isPutObjectRequestBuilderSetter(method);
    }

    public static boolean isSetterForClassType(J.MethodInvocation method, String fqcn) {
        if (method.getSelect() == null || method.getSelect().getType() == null) {
            return false;
        }
        return S3TransformUtils.hasArguments(method) && TypeUtils.isOfClassType((JavaType)method.getSelect().getType(), (String)fqcn);
    }

    public static boolean hasArguments(J.MethodInvocation method) {
        return !method.getArguments().isEmpty();
    }

    public static boolean isPayloadSetter(J.MethodInvocation method) {
        return "file".equals(method.getSimpleName()) || "inputStream".equals(method.getSimpleName());
    }

    public static boolean isRequestPayerSetter(J.MethodInvocation method) {
        return "requestPayer".equals(method.getSimpleName());
    }

    public static boolean isRequestMetadataSetter(J.MethodInvocation method) {
        return "metadata".equals(method.getSimpleName());
    }

    public static boolean isCompleteMpuRequestMultipartUploadSetter(J.MethodInvocation method) {
        return "multipartUpload".equals(method.getSimpleName()) && TypeUtils.isAssignableTo((String)"software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest.Builder", (JavaType)method.getSelect().getType());
    }

    public static boolean isGetObjectRequestPayerSetter(J.MethodInvocation method) {
        return "requestPayer".equals(method.getSimpleName()) && TypeUtils.isAssignableTo((String)"software.amazon.awssdk.services.s3.model.GetObjectRequest.Builder", (JavaType)method.getSelect().getType());
    }

    public static boolean isRestoreObjectRequestDaysSetter(J.MethodInvocation method) {
        return "days".equals(method.getSimpleName()) && TypeUtils.isAssignableTo((String)"software.amazon.awssdk.services.s3.model.RestoreObjectRequest.Builder", (JavaType)method.getSelect().getType());
    }

    public static boolean isGeneratePresignedUrl(J.MethodInvocation method) {
        return "generatePresignedUrl".equals(method.getSimpleName()) && TypeUtils.isAssignableTo((String)V2_S3_CLIENT, (JavaType)method.getSelect().getType());
    }

    public static boolean isGetS3AccountOwner(J.MethodInvocation method) {
        return "getS3AccountOwner".equals(method.getSimpleName()) && TypeUtils.isAssignableTo((String)V2_S3_CLIENT, (JavaType)method.getSelect().getType());
    }

    public static boolean isUnsupportedHttpMethod(String httpMethod) {
        return Arrays.asList("Head", "Post", "Patch").contains(httpMethod);
    }

    public static List<Comment> inputStreamBufferingWarningComment() {
        String warning = "When using InputStream to upload with S3Client, Content-Length should be specified and used with RequestBody.fromInputStream(). Otherwise, the entire stream will be buffered in memory. If content length must be unknown, we recommend using the CRT-based S3 client - https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/crt-based-s3-client.html";
        return S3TransformUtils.createComments(warning);
    }

    public static List<Comment> assignedVariableHttpMethodNotSupportedComment() {
        String comment = "Transform for S3 generatePresignedUrl() with an assigned variable for HttpMethod is not supported. Please manually migrate your code - https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/s3/presigner/S3Presigner.html";
        return S3TransformUtils.createComments(comment);
    }

    public static List<Comment> requestPojoTransformNotSupportedComment() {
        String comment = "Transforms are not supported for GeneratePresignedUrlRequest, please manually migrate your code - https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/s3/presigner/S3Presigner.html";
        return S3TransformUtils.createComments(comment);
    }

    public static List<Comment> httpMethodNotSupportedComment(String httpMethod) {
        String comment = String.format("S3 generatePresignedUrl() with %s HTTP method is not supported in v2. Only GET, PUT, and DELETE are supported - https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/s3/presigner/S3Presigner.html", httpMethod.toUpperCase(Locale.ROOT));
        return S3TransformUtils.createComments(comment);
    }

    public static List<Comment> presignerSingleInstanceSuggestion() {
        String comment = "If generating multiple pre-signed URLs, it is recommended to create a single instance of S3Presigner, since creating a presigner can be expensive. If applicable, please manually refactor the transformed code.";
        return S3TransformUtils.createCommentsWithNewline(comment);
    }

    public static J.MethodInvocation sseAwsKeyManagementParamsNotSupportedComment(J.MethodInvocation method) {
        String comment = "Transform for PutObjectRequest setter sseAwsKeyManagementParam is not supported, please manually migrate your code to use the v2 setters: ssekmsKeyId, serverSideEncryption, sseCustomerAlgorithm - https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/s3/model/PutObjectRequest.Builder.html#ssekmsKeyId(java.lang.String)";
        return S3TransformUtils.appendCommentToMethod(method, comment);
    }

    public static J.MethodInvocation sseCustomerKeyNotSupportedComment(J.MethodInvocation method) {
        String comment = "Transform for PutObjectRequest setter sseCustomerKey is not supported, please manually migrate your code to use the v2 setters: sseCustomerKey, sseCustomerKeyMD5 - https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/s3/model/PutObjectRequest.Builder.html#sseCustomerKey(java.lang.String)";
        return S3TransformUtils.appendCommentToMethod(method, comment);
    }

    public static J.MethodInvocation accessControlListNotSupportedComment(J.MethodInvocation method) {
        String comment = "Transform for PutObjectRequest setter accessControlList is not supported, please manually migrate your code to use the v2 setters: acl, grantReadACP, grantWriteACP - https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/s3/model/PutObjectRequest.Builder.html#acl(java.lang.String)";
        return S3TransformUtils.appendCommentToMethod(method, comment);
    }

    public static J.MethodInvocation addCommentForUnsupportedPutObjectRequestSetter(J.MethodInvocation method) {
        String methodName;
        switch (methodName = method.getSimpleName()) {
            case "sseCustomerKey": {
                return S3TransformUtils.sseAwsKeyManagementParamsNotSupportedComment(method);
            }
            case "sseAwsKeyManagementParams": {
                return S3TransformUtils.sseCustomerKeyNotSupportedComment(method);
            }
            case "accessControlList": {
                return S3TransformUtils.accessControlListNotSupportedComment(method);
            }
        }
        return method;
    }

    public static J.MethodInvocation appendCommentToMethod(J.MethodInvocation method, String comment) {
        if (method.getComments().isEmpty()) {
            return (J.MethodInvocation)method.withComments(S3TransformUtils.createCommentsWithNewline(comment));
        }
        List existingComments = method.getComments();
        existingComments.add(S3TransformUtils.createCommentWithNewline(comment));
        return (J.MethodInvocation)method.withComments(existingComments);
    }
}

