/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.S3TransformUtils;

@SdkInternalApi
public class TransferManagerMethodsToV2
extends Recipe {
    private static final MethodMatcher DOWNLOAD_BUCKET_KEY_FILE = S3TransformUtils.v2TmMethodMatcher("download(String, String, java.io.File)");
    private static final MethodMatcher DOWNLOAD_BUCKET_KEY_FILE_TIMEOUT = S3TransformUtils.v2TmMethodMatcher("download(String, String, java.io.File, long)");
    private static final MethodMatcher DOWNLOAD_REQUEST_FILE = S3TransformUtils.v2TmMethodMatcher(String.format("download(%sGetObjectRequest, java.io.File)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher DOWNLOAD_REQUEST_FILE_TIMEOUT = S3TransformUtils.v2TmMethodMatcher(String.format("download(%sGetObjectRequest, java.io.File, long)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher UPLOAD_BUCKET_KEY_FILE = S3TransformUtils.v2TmMethodMatcher("upload(String, String, java.io.File)");
    private static final MethodMatcher COPY_REQUEST = S3TransformUtils.v2TmMethodMatcher(String.format("copy(%sCopyObjectRequest)", "software.amazon.awssdk.services.s3.model."));
    private static final MethodMatcher COPY_BUCKET_KEY = S3TransformUtils.v2TmMethodMatcher("copy(String, String, String, String");

    public String getDisplayName() {
        return "Transfer Manager Methods to V2";
    }

    public String getDescription() {
        return "Transfer Manager Methods to V2";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (DOWNLOAD_BUCKET_KEY_FILE.matches(method, false)) {
                method = this.transformDownloadWithBucketKeyFile(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (DOWNLOAD_BUCKET_KEY_FILE_TIMEOUT.matches(method, false)) {
                method = this.transformDownloadWithBucketKeyFileTimeout(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (DOWNLOAD_REQUEST_FILE.matches(method, false)) {
                method = this.transformDownloadWithRequestFile(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (DOWNLOAD_REQUEST_FILE_TIMEOUT.matches(method, false)) {
                method = this.transformDownloadWithRequestFileTimeout(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (COPY_REQUEST.matches(method, false)) {
                method = this.transformCopyWithRequest(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (COPY_BUCKET_KEY.matches(method, false)) {
                method = this.transformCopyWithBucketKey(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            if (UPLOAD_BUCKET_KEY_FILE.matches(method, false)) {
                method = this.transformUploadWithBucketKeyFile(method);
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }

        private J.MethodInvocation transformUploadWithBucketKeyFile(J.MethodInvocation method) {
            String v2Method = "#{any()}.uploadFile(UploadFileRequest.builder().putObjectRequest(PutObjectRequest.builder().bucket(#{any()}).key(#{any()}).build()).source(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addTmImport("UploadFileRequest");
            this.addS3Import("PutObjectRequest");
            return method;
        }

        private J.MethodInvocation transformCopyWithRequest(J.MethodInvocation method) {
            String v2Method = "#{any()}.copy(CopyRequest.builder().copyObjectRequest(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0)});
            this.addTmImport("CopyRequest");
            return method;
        }

        private J.MethodInvocation transformCopyWithBucketKey(J.MethodInvocation method) {
            String v2Method = "#{any()}.copy(CopyRequest.builder().copyObjectRequest(CopyObjectRequest.builder().sourceBucket(#{any()}).sourceKey(#{any()}).destinationBucket(#{any()}).destinationKey(#{any()}).build()).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2), method.getArguments().get(3)});
            this.addTmImport("CopyRequest");
            this.addS3Import("CopyObjectRequest");
            return method;
        }

        private J.MethodInvocation transformDownloadWithRequestFile(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadFile(DownloadFileRequest.builder().getObjectRequest(#{any()}).destination(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1)});
            this.addTmImport("DownloadFileRequest");
            return method;
        }

        private J.MethodInvocation transformDownloadWithRequestFileTimeout(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadFile(DownloadFileRequest.builder().getObjectRequest(#{any()}.toBuilder().overrideConfiguration(#{any()}.overrideConfiguration().get().toBuilder().apiCallTimeout(Duration.ofMillis(#{any()})).build()).build()).destination(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(0), method.getArguments().get(2), method.getArguments().get(1)});
            this.addTmImport("DownloadFileRequest");
            return method;
        }

        private J.MethodInvocation transformDownloadWithBucketKeyFile(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadFile(DownloadFileRequest.builder().getObjectRequest(GetObjectRequest.builder().bucket(#{any()}).key(#{any()}).build()).destination(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(2)});
            this.addTmImport("DownloadFileRequest");
            this.addS3Import("GetObjectRequest");
            return method;
        }

        private J.MethodInvocation transformDownloadWithBucketKeyFileTimeout(J.MethodInvocation method) {
            String v2Method = "#{any()}.downloadFile(DownloadFileRequest.builder().getObjectRequest(GetObjectRequest.builder().bucket(#{any()}).key(#{any()}).overrideConfiguration(AwsRequestOverrideConfiguration.builder().apiCallTimeout(Duration.ofMillis(#{any()})).build()).build()).destination(#{any()}).build())";
            method = (J.MethodInvocation)JavaTemplate.builder((String)v2Method).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect(), method.getArguments().get(0), method.getArguments().get(1), method.getArguments().get(3), method.getArguments().get(2)});
            this.addTmImport("DownloadFileRequest");
            this.addS3Import("GetObjectRequest");
            this.addRequestOverrideConfigImport();
            this.addDurationImport();
            return method;
        }

        private void addTmImport(String pojoName) {
            String fqcn = "software.amazon.awssdk.transfer.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addS3Import(String pojoName) {
            String fqcn = "software.amazon.awssdk.services.s3.model." + pojoName;
            this.doAfterVisit((TreeVisitor)new AddImport(fqcn, null, false));
        }

        private void addDurationImport() {
            this.doAfterVisit((TreeVisitor)new AddImport("java.time.Duration", null, false));
        }

        private void addRequestOverrideConfigImport() {
            this.doAfterVisit((TreeVisitor)new AddImport("software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration", null, false));
        }
    }
}

