/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.v2migration.internal.utils.IdentifierUtils;

@SdkInternalApi
public class S3StreamingRequestToV2
extends Recipe {
    private static final MethodMatcher PUT_OBJECT_FILE = new MethodMatcher("com.amazonaws.services.s3.AmazonS3 putObject(java.lang.String, java.lang.String, java.io.File)", true);
    private static final MethodMatcher PUT_OBJECT_STRING = new MethodMatcher("com.amazonaws.services.s3.AmazonS3 putObject(java.lang.String, java.lang.String, java.lang.String)", true);
    private static final JavaType.FullyQualified V1_PUT_OBJECT_REQUEST = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)"com.amazonaws.services.s3.model.PutObjectRequest"));
    private static final JavaType.FullyQualified REQUEST_BODY = TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)"software.amazon.awssdk.core.sync.RequestBody"));

    public String getDisplayName() {
        return "V1 S3 streaming requests to V2";
    }

    public String getDescription() {
        return "Transform usage of V1 S3 streaming requests such as PutObject to V2.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new Visitor();
    }

    private static final class Visitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Visitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            if (PUT_OBJECT_FILE.matches(method, false)) {
                method = this.transformPutFileOverload(method);
            } else if (PUT_OBJECT_STRING.matches(method, false)) {
                method = this.transformPutStringOverload(method);
            }
            return super.visitMethodInvocation(method, (Object)executionContext);
        }

        private J.MethodInvocation transformPutStringOverload(J.MethodInvocation method) {
            JavaType.Method methodType = method.getMethodType();
            if (methodType == null) {
                return method;
            }
            List originalArgs = method.getArguments();
            Expression bucketExpr = (Expression)originalArgs.get(0);
            Expression keyExpr = (Expression)originalArgs.get(1);
            Expression stringExpr = (Expression)originalArgs.get(2);
            ArrayList<Expression> newArgs = new ArrayList<Expression>();
            Expression getObjectExpr = this.bucketAndKeyToPutObject(bucketExpr, keyExpr);
            newArgs.add(getObjectExpr);
            Space stringArgPrefix = stringExpr.getPrefix();
            stringExpr = this.stringToRequestBody((Expression)stringExpr.withPrefix(Space.EMPTY)).withPrefix(stringArgPrefix);
            newArgs.add(stringExpr);
            List<String> paramNames = Arrays.asList("request", "stringContent");
            List paramTypes = newArgs.stream().map(Expression::getType).collect(Collectors.toList());
            methodType = methodType.withParameterTypes(paramTypes).withParameterNames(paramNames);
            return method.withMethodType(methodType).withArguments(newArgs);
        }

        private J.MethodInvocation stringToRequestBody(Expression fileExpr) {
            this.maybeAddImport(REQUEST_BODY);
            J.Identifier requestBodyId = IdentifierUtils.makeId(REQUEST_BODY.getClassName(), (JavaType)REQUEST_BODY);
            JavaType.Method fromStringType = new JavaType.Method(null, 0L, REQUEST_BODY, "fromString", (JavaType)REQUEST_BODY, Collections.singletonList("stringContent"), Collections.singletonList(JavaType.buildType((String)"java.lang.String")), null, null);
            J.Identifier fromFileId = IdentifierUtils.makeId("fromString", (JavaType)fromStringType);
            return new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)requestBodyId), null, fromFileId, JContainer.build(Collections.singletonList(JRightPadded.build((Object)fileExpr))), fromStringType);
        }

        private J.MethodInvocation transformPutFileOverload(J.MethodInvocation method) {
            JavaType.Method methodType = method.getMethodType();
            if (methodType == null) {
                return method;
            }
            List originalArgs = method.getArguments();
            Expression bucketExpr = (Expression)originalArgs.get(0);
            Expression keyExpr = (Expression)originalArgs.get(1);
            Expression fileExpr = (Expression)originalArgs.get(2);
            ArrayList<Expression> newArgs = new ArrayList<Expression>();
            Expression getObjectExpr = this.bucketAndKeyToPutObject(bucketExpr, keyExpr);
            newArgs.add(getObjectExpr);
            Space fileArgPrefix = fileExpr.getPrefix();
            fileExpr = this.fileToRequestBody((Expression)fileExpr.withPrefix(Space.EMPTY)).withPrefix(fileArgPrefix);
            newArgs.add(fileExpr);
            List<String> paramNames = Arrays.asList("request", "file");
            List paramTypes = newArgs.stream().map(Expression::getType).collect(Collectors.toList());
            methodType = methodType.withParameterTypes(paramTypes).withParameterNames(paramNames);
            return method.withMethodType(methodType).withArguments(newArgs);
        }

        private J.MethodInvocation fileToRequestBody(Expression fileExpr) {
            this.maybeAddImport(REQUEST_BODY);
            J.Identifier requestBodyId = IdentifierUtils.makeId(REQUEST_BODY.getClassName(), (JavaType)REQUEST_BODY);
            JavaType.Method fromFileType = new JavaType.Method(null, 0L, REQUEST_BODY, "fromFile", (JavaType)REQUEST_BODY, Collections.singletonList("file"), Collections.singletonList(JavaType.buildType((String)"java.io.File")), null, null);
            J.Identifier fromFileId = IdentifierUtils.makeId("fromFile", (JavaType)fromFileType);
            return new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)requestBodyId), null, fromFileId, JContainer.build(Collections.singletonList(JRightPadded.build((Object)fileExpr))), fromFileType);
        }

        private Expression bucketAndKeyToPutObject(Expression bucketExpr, Expression keyExpr) {
            this.maybeAddImport(V1_PUT_OBJECT_REQUEST);
            J.Identifier putObjRequestId = IdentifierUtils.makeId(V1_PUT_OBJECT_REQUEST.getClassName(), (JavaType)V1_PUT_OBJECT_REQUEST);
            JavaType.Method ctorType = new JavaType.Method(null, 0L, V1_PUT_OBJECT_REQUEST, "<init>", (JavaType)V1_PUT_OBJECT_REQUEST, Arrays.asList("bucket", "key"), Arrays.asList(bucketExpr.getType(), keyExpr.getType()), null, null);
            return new J.NewClass(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, Space.EMPTY, (TypeTree)putObjRequestId.withPrefix(Space.SINGLE_SPACE), JContainer.build(Arrays.asList(JRightPadded.build((Object)bucketExpr), JRightPadded.build((Object)keyExpr))), null, ctorType);
        }
    }
}

