/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.utils.StringUtils;

public final class Logger {
    private final Log log;

    Logger(Log log) {
        this.log = log;
    }

    public void info(Supplier<String> msg) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)msg.get());
        }
    }

    public void info(Supplier<String> msg, Throwable throwable) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)msg.get(), throwable);
        }
    }

    public void error(Supplier<String> msg) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)msg.get());
        }
    }

    public void error(Supplier<String> msg, Throwable throwable) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)msg.get(), throwable);
        }
    }

    public void debug(Supplier<String> msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)msg.get());
        }
    }

    public void debug(Supplier<String> msg, Throwable throwable) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)msg.get(), throwable);
        }
    }

    public void warn(Supplier<String> msg) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)msg.get());
        }
    }

    public void warn(Supplier<String> msg, Throwable throwable) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)msg.get(), throwable);
        }
    }

    public void trace(Supplier<String> msg) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)msg.get());
        }
    }

    public void trace(Supplier<String> msg, Throwable throwable) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)msg.get(), throwable);
        }
    }

    public boolean isLoggingLevelEnabled(String logLevel) {
        String lowerLogLevel;
        switch (lowerLogLevel = StringUtils.lowerCase(logLevel)) {
            case "debug": {
                return this.log.isDebugEnabled();
            }
            case "trace": {
                return this.log.isTraceEnabled();
            }
            case "error": {
                return this.log.isErrorEnabled();
            }
            case "info": {
                return this.log.isInfoEnabled();
            }
            case "warn": {
                return this.log.isWarnEnabled();
            }
            case "fatal": {
                return this.log.isFatalEnabled();
            }
        }
        throw new IllegalArgumentException("Unknown log level: " + lowerLogLevel);
    }

    public static Logger loggerFor(Class<?> clz) {
        return new Logger(LogFactory.getLog(clz));
    }
}

