/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum IoUtils {

    private static final int BUFFER_SIZE = 4096;
    private static final Log DEFAULT_LOG = LogFactory.getLog(IoUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream is) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] b = new byte[4096];
            int n = 0;
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String toString(InputStream is) throws IOException {
        return new String(IoUtils.toByteArray(is), StandardCharsets.UTF_8);
    }

    public static void closeQuietly(AutoCloseable is, Log log) {
        block3: {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    Log logger;
                    Log log2 = logger = log == null ? DEFAULT_LOG : log;
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)"Ignore failure in closing the Closeable", (Throwable)ex);
                }
            }
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4096];
        long count = 0L;
        int n = 0;
        while ((n = in.read(buf)) > -1) {
            out.write(buf, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void drainInputStream(InputStream in) {
        try {
            while (in.read() != -1) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

