/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationSource {
    AWS_CONFIG("aws_config"),
    COMPUTE_OPTIMIZER("compute_optimizer"),
    COST_EXPLORER("cost_explorer"),
    LSE("lse"),
    MANUAL("manual"),
    PSE("pse"),
    RDS("rds"),
    RESILIENCE("resilience"),
    RESILIENCE_HUB("resilience_hub"),
    SECURITY_HUB("security_hub"),
    STIR("stir"),
    TA_CHECK("ta_check"),
    WELL_ARCHITECTED("well_architected"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationSource> VALUE_MAP;
    private final String value;

    private RecommendationSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationSource> knownValues() {
        EnumSet<RecommendationSource> knownValues = EnumSet.allOf(RecommendationSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationSource.class, RecommendationSource::toString);
    }
}

