/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranslatedDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TranslatedDocument> {
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Content").getter(TranslatedDocument.getter(TranslatedDocument::content)).setter(TranslatedDocument.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TranslatedDocument.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SdkBytes content;

    private TranslatedDocument(BuilderImpl builder) {
        this.content = builder.content;
    }

    public final SdkBytes content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslatedDocument)) {
            return false;
        }
        TranslatedDocument other = (TranslatedDocument)obj;
        return Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"TranslatedDocument").add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkBytes>> map = new HashMap<String, SdkField<SdkBytes>>();
        map.put("Content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranslatedDocument, T> g) {
        return obj -> g.apply((TranslatedDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes content;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslatedDocument model) {
            this.content(model.content);
        }

        public final ByteBuffer getContent() {
            return this.content == null ? null : this.content.asByteBuffer();
        }

        public final void setContent(ByteBuffer content) {
            this.content(content == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)content));
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = content;
            return this;
        }

        public TranslatedDocument build() {
            return new TranslatedDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TranslatedDocument> {
        public Builder content(SdkBytes var1);
    }
}

