/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.translate.TranslateAsyncClient;
import software.amazon.awssdk.services.translate.model.ListLanguagesRequest;
import software.amazon.awssdk.services.translate.model.ListLanguagesResponse;

public class ListLanguagesPublisher
implements SdkPublisher<ListLanguagesResponse> {
    private final TranslateAsyncClient client;
    private final ListLanguagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLanguagesPublisher(TranslateAsyncClient client, ListLanguagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLanguagesPublisher(TranslateAsyncClient client, ListLanguagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLanguagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLanguagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLanguagesResponseFetcher
    implements AsyncPageFetcher<ListLanguagesResponse> {
        private ListLanguagesResponseFetcher() {
        }

        public boolean hasNextPage(ListLanguagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLanguagesResponse> nextPage(ListLanguagesResponse previousPage) {
            if (previousPage == null) {
                return ListLanguagesPublisher.this.client.listLanguages(ListLanguagesPublisher.this.firstRequest);
            }
            return ListLanguagesPublisher.this.client.listLanguages((ListLanguagesRequest)((Object)ListLanguagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

