/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.EncryptionKey;
import software.amazon.awssdk.services.translate.model.LanguageCodeStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminologyProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TerminologyProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TerminologyProperties.getter(TerminologyProperties::name)).setter(TerminologyProperties.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TerminologyProperties.getter(TerminologyProperties::description)).setter(TerminologyProperties.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TerminologyProperties.getter(TerminologyProperties::arn)).setter(TerminologyProperties.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLanguageCode").getter(TerminologyProperties.getter(TerminologyProperties::sourceLanguageCode)).setter(TerminologyProperties.setter(Builder::sourceLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build()}).build();
    private static final SdkField<List<String>> TARGET_LANGUAGE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLanguageCodes").getter(TerminologyProperties.getter(TerminologyProperties::targetLanguageCodes)).setter(TerminologyProperties.setter(Builder::targetLanguageCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EncryptionKey> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionKey").getter(TerminologyProperties.getter(TerminologyProperties::encryptionKey)).setter(TerminologyProperties.setter(Builder::encryptionKey)).constructor(EncryptionKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()}).build();
    private static final SdkField<Integer> SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SizeBytes").getter(TerminologyProperties.getter(TerminologyProperties::sizeBytes)).setter(TerminologyProperties.setter(Builder::sizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeBytes").build()}).build();
    private static final SdkField<Integer> TERM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TermCount").getter(TerminologyProperties.getter(TerminologyProperties::termCount)).setter(TerminologyProperties.setter(Builder::termCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermCount").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(TerminologyProperties.getter(TerminologyProperties::createdAt)).setter(TerminologyProperties.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(TerminologyProperties.getter(TerminologyProperties::lastUpdatedAt)).setter(TerminologyProperties.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ARN_FIELD, SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODES_FIELD, ENCRYPTION_KEY_FIELD, SIZE_BYTES_FIELD, TERM_COUNT_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String arn;
    private final String sourceLanguageCode;
    private final List<String> targetLanguageCodes;
    private final EncryptionKey encryptionKey;
    private final Integer sizeBytes;
    private final Integer termCount;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private TerminologyProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.arn = builder.arn;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCodes = builder.targetLanguageCodes;
        this.encryptionKey = builder.encryptionKey;
        this.sizeBytes = builder.sizeBytes;
        this.termCount = builder.termCount;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String arn() {
        return this.arn;
    }

    public final String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public final boolean hasTargetLanguageCodes() {
        return this.targetLanguageCodes != null && !(this.targetLanguageCodes instanceof SdkAutoConstructList);
    }

    public final List<String> targetLanguageCodes() {
        return this.targetLanguageCodes;
    }

    public final EncryptionKey encryptionKey() {
        return this.encryptionKey;
    }

    public final Integer sizeBytes() {
        return this.sizeBytes;
    }

    public final Integer termCount() {
        return this.termCount;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLanguageCodes() ? this.targetLanguageCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.termCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminologyProperties)) {
            return false;
        }
        TerminologyProperties other = (TerminologyProperties)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && this.hasTargetLanguageCodes() == other.hasTargetLanguageCodes() && Objects.equals(this.targetLanguageCodes(), other.targetLanguageCodes()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.sizeBytes(), other.sizeBytes()) && Objects.equals(this.termCount(), other.termCount()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"TerminologyProperties").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCodes", this.hasTargetLanguageCodes() ? this.targetLanguageCodes() : null).add("EncryptionKey", (Object)this.encryptionKey()).add("SizeBytes", (Object)this.sizeBytes()).add("TermCount", (Object)this.termCount()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "SourceLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCodes": {
                return Optional.ofNullable(clazz.cast(this.targetLanguageCodes()));
            }
            case "EncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "SizeBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeBytes()));
            }
            case "TermCount": {
                return Optional.ofNullable(clazz.cast(this.termCount()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminologyProperties, T> g) {
        return obj -> g.apply((TerminologyProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String arn;
        private String sourceLanguageCode;
        private List<String> targetLanguageCodes = DefaultSdkAutoConstructList.getInstance();
        private EncryptionKey encryptionKey;
        private Integer sizeBytes;
        private Integer termCount;
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminologyProperties model) {
            this.name(model.name);
            this.description(model.description);
            this.arn(model.arn);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCodes(model.targetLanguageCodes);
            this.encryptionKey(model.encryptionKey);
            this.sizeBytes(model.sizeBytes);
            this.termCount(model.termCount);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        @Override
        @Transient
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final Collection<String> getTargetLanguageCodes() {
            if (this.targetLanguageCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetLanguageCodes;
        }

        public final void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = LanguageCodeStringListCopier.copy(targetLanguageCodes);
        }

        @Override
        @Transient
        public final Builder targetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = LanguageCodeStringListCopier.copy(targetLanguageCodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetLanguageCodes(String ... targetLanguageCodes) {
            this.targetLanguageCodes(Arrays.asList(targetLanguageCodes));
            return this;
        }

        public final EncryptionKey.Builder getEncryptionKey() {
            return this.encryptionKey != null ? this.encryptionKey.toBuilder() : null;
        }

        public final void setEncryptionKey(EncryptionKey.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Integer getSizeBytes() {
            return this.sizeBytes;
        }

        public final void setSizeBytes(Integer sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        @Override
        @Transient
        public final Builder sizeBytes(Integer sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final Integer getTermCount() {
            return this.termCount;
        }

        public final void setTermCount(Integer termCount) {
            this.termCount = termCount;
        }

        @Override
        @Transient
        public final Builder termCount(Integer termCount) {
            this.termCount = termCount;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public TerminologyProperties build() {
            return new TerminologyProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TerminologyProperties> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCodes(Collection<String> var1);

        public Builder targetLanguageCodes(String ... var1);

        public Builder encryptionKey(EncryptionKey var1);

        default public Builder encryptionKey(Consumer<EncryptionKey.Builder> encryptionKey) {
            return this.encryptionKey((EncryptionKey)((EncryptionKey.Builder)EncryptionKey.builder().applyMutation(encryptionKey)).build());
        }

        public Builder sizeBytes(Integer var1);

        public Builder termCount(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

