/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.model.ListLanguagesRequest;
import software.amazon.awssdk.services.translate.model.ListLanguagesResponse;

public class ListLanguagesIterable
implements SdkIterable<ListLanguagesResponse> {
    private final TranslateClient client;
    private final ListLanguagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLanguagesIterable(TranslateClient client, ListLanguagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLanguagesResponseFetcher();
    }

    public Iterator<ListLanguagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLanguagesResponseFetcher
    implements SyncPageFetcher<ListLanguagesResponse> {
        private ListLanguagesResponseFetcher() {
        }

        public boolean hasNextPage(ListLanguagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLanguagesResponse nextPage(ListLanguagesResponse previousPage) {
            if (previousPage == null) {
                return ListLanguagesIterable.this.client.listLanguages(ListLanguagesIterable.this.firstRequest);
            }
            return ListLanguagesIterable.this.client.listLanguages((ListLanguagesRequest)((Object)ListLanguagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

