/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse;

public class ListTextTranslationJobsIterable
implements SdkIterable<ListTextTranslationJobsResponse> {
    private final TranslateClient client;
    private final ListTextTranslationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTextTranslationJobsIterable(TranslateClient client, ListTextTranslationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTextTranslationJobsResponseFetcher();
    }

    public Iterator<ListTextTranslationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTextTranslationJobsResponseFetcher
    implements SyncPageFetcher<ListTextTranslationJobsResponse> {
        private ListTextTranslationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTextTranslationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTextTranslationJobsResponse nextPage(ListTextTranslationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTextTranslationJobsIterable.this.client.listTextTranslationJobs(ListTextTranslationJobsIterable.this.firstRequest);
            }
            return ListTextTranslationJobsIterable.this.client.listTextTranslationJobs((ListTextTranslationJobsRequest)((Object)ListTextTranslationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

