/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.TextTranslationJobProperties;
import software.amazon.awssdk.services.translate.model.TextTranslationJobPropertiesListCopier;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTextTranslationJobsResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, ListTextTranslationJobsResponse> {
    private static final SdkField<List<TextTranslationJobProperties>> TEXT_TRANSLATION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TextTranslationJobPropertiesList").getter(ListTextTranslationJobsResponse.getter(ListTextTranslationJobsResponse::textTranslationJobPropertiesList)).setter(ListTextTranslationJobsResponse.setter(Builder::textTranslationJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTranslationJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TextTranslationJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTextTranslationJobsResponse.getter(ListTextTranslationJobsResponse::nextToken)).setter(ListTextTranslationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_TRANSLATION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<TextTranslationJobProperties> textTranslationJobPropertiesList;
    private final String nextToken;

    private ListTextTranslationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.textTranslationJobPropertiesList = builder.textTranslationJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTextTranslationJobPropertiesList() {
        return this.textTranslationJobPropertiesList != null && !(this.textTranslationJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<TextTranslationJobProperties> textTranslationJobPropertiesList() {
        return this.textTranslationJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTextTranslationJobPropertiesList() ? this.textTranslationJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTextTranslationJobsResponse)) {
            return false;
        }
        ListTextTranslationJobsResponse other = (ListTextTranslationJobsResponse)((Object)obj);
        return this.hasTextTranslationJobPropertiesList() == other.hasTextTranslationJobPropertiesList() && Objects.equals(this.textTranslationJobPropertiesList(), other.textTranslationJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTextTranslationJobsResponse").add("TextTranslationJobPropertiesList", this.hasTextTranslationJobPropertiesList() ? this.textTranslationJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextTranslationJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.textTranslationJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTextTranslationJobsResponse, T> g) {
        return obj -> g.apply((ListTextTranslationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private List<TextTranslationJobProperties> textTranslationJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTextTranslationJobsResponse model) {
            super(model);
            this.textTranslationJobPropertiesList(model.textTranslationJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<TextTranslationJobProperties.Builder> getTextTranslationJobPropertiesList() {
            if (this.textTranslationJobPropertiesList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.textTranslationJobPropertiesList != null ? (Collection)this.textTranslationJobPropertiesList.stream().map(TextTranslationJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder textTranslationJobPropertiesList(Collection<TextTranslationJobProperties> textTranslationJobPropertiesList) {
            this.textTranslationJobPropertiesList = TextTranslationJobPropertiesListCopier.copy(textTranslationJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTranslationJobPropertiesList(TextTranslationJobProperties ... textTranslationJobPropertiesList) {
            this.textTranslationJobPropertiesList(Arrays.asList(textTranslationJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textTranslationJobPropertiesList(Consumer<TextTranslationJobProperties.Builder> ... textTranslationJobPropertiesList) {
            this.textTranslationJobPropertiesList(Stream.of(textTranslationJobPropertiesList).map(c -> (TextTranslationJobProperties)((TextTranslationJobProperties.Builder)TextTranslationJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTextTranslationJobPropertiesList(Collection<TextTranslationJobProperties.BuilderImpl> textTranslationJobPropertiesList) {
            this.textTranslationJobPropertiesList = TextTranslationJobPropertiesListCopier.copyFromBuilder(textTranslationJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTextTranslationJobsResponse build() {
            return new ListTextTranslationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTextTranslationJobsResponse> {
        public Builder textTranslationJobPropertiesList(Collection<TextTranslationJobProperties> var1);

        public Builder textTranslationJobPropertiesList(TextTranslationJobProperties ... var1);

        public Builder textTranslationJobPropertiesList(Consumer<TextTranslationJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

