/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.InputDataConfig;
import software.amazon.awssdk.services.translate.model.OutputDataConfig;
import software.amazon.awssdk.services.translate.model.ResourceNameListCopier;
import software.amazon.awssdk.services.translate.model.TargetLanguageCodeStringListCopier;
import software.amazon.awssdk.services.translate.model.TranslateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTextTranslationJobRequest
extends TranslateRequest
implements ToCopyableBuilder<Builder, StartTextTranslationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::jobName)).setter(StartTextTranslationJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::inputDataConfig)).setter(StartTextTranslationJobRequest.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::outputDataConfig)).setter(StartTextTranslationJobRequest.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::dataAccessRoleArn)).setter(StartTextTranslationJobRequest.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLanguageCode").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::sourceLanguageCode)).setter(StartTextTranslationJobRequest.setter(Builder::sourceLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build()}).build();
    private static final SdkField<List<String>> TARGET_LANGUAGE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLanguageCodes").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::targetLanguageCodes)).setter(StartTextTranslationJobRequest.setter(Builder::targetLanguageCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TERMINOLOGY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TerminologyNames").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::terminologyNames)).setter(StartTextTranslationJobRequest.setter(Builder::terminologyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PARALLEL_DATA_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParallelDataNames").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::parallelDataNames)).setter(StartTextTranslationJobRequest.setter(Builder::parallelDataNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartTextTranslationJobRequest.getter(StartTextTranslationJobRequest::clientToken)).setter(StartTextTranslationJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODES_FIELD, TERMINOLOGY_NAMES_FIELD, PARALLEL_DATA_NAMES_FIELD, CLIENT_TOKEN_FIELD));
    private final String jobName;
    private final InputDataConfig inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final String dataAccessRoleArn;
    private final String sourceLanguageCode;
    private final List<String> targetLanguageCodes;
    private final List<String> terminologyNames;
    private final List<String> parallelDataNames;
    private final String clientToken;

    private StartTextTranslationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCodes = builder.targetLanguageCodes;
        this.terminologyNames = builder.terminologyNames;
        this.parallelDataNames = builder.parallelDataNames;
        this.clientToken = builder.clientToken;
    }

    public String jobName() {
        return this.jobName;
    }

    public InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public boolean hasTargetLanguageCodes() {
        return this.targetLanguageCodes != null && !(this.targetLanguageCodes instanceof SdkAutoConstructList);
    }

    public List<String> targetLanguageCodes() {
        return this.targetLanguageCodes;
    }

    public boolean hasTerminologyNames() {
        return this.terminologyNames != null && !(this.terminologyNames instanceof SdkAutoConstructList);
    }

    public List<String> terminologyNames() {
        return this.terminologyNames;
    }

    public boolean hasParallelDataNames() {
        return this.parallelDataNames != null && !(this.parallelDataNames instanceof SdkAutoConstructList);
    }

    public List<String> parallelDataNames() {
        return this.parallelDataNames;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLanguageCodes() ? this.targetLanguageCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTerminologyNames() ? this.terminologyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParallelDataNames() ? this.parallelDataNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTextTranslationJobRequest)) {
            return false;
        }
        StartTextTranslationJobRequest other = (StartTextTranslationJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && this.hasTargetLanguageCodes() == other.hasTargetLanguageCodes() && Objects.equals(this.targetLanguageCodes(), other.targetLanguageCodes()) && this.hasTerminologyNames() == other.hasTerminologyNames() && Objects.equals(this.terminologyNames(), other.terminologyNames()) && this.hasParallelDataNames() == other.hasParallelDataNames() && Objects.equals(this.parallelDataNames(), other.parallelDataNames()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"StartTextTranslationJobRequest").add("JobName", (Object)this.jobName()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCodes", this.hasTargetLanguageCodes() ? this.targetLanguageCodes() : null).add("TerminologyNames", this.hasTerminologyNames() ? this.terminologyNames() : null).add("ParallelDataNames", this.hasParallelDataNames() ? this.parallelDataNames() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "SourceLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCodes": {
                return Optional.ofNullable(clazz.cast(this.targetLanguageCodes()));
            }
            case "TerminologyNames": {
                return Optional.ofNullable(clazz.cast(this.terminologyNames()));
            }
            case "ParallelDataNames": {
                return Optional.ofNullable(clazz.cast(this.parallelDataNames()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTextTranslationJobRequest, T> g) {
        return obj -> g.apply((StartTextTranslationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private InputDataConfig inputDataConfig;
        private OutputDataConfig outputDataConfig;
        private String dataAccessRoleArn;
        private String sourceLanguageCode;
        private List<String> targetLanguageCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> terminologyNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> parallelDataNames = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTextTranslationJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCodes(model.targetLanguageCodes);
            this.terminologyNames(model.terminologyNames);
            this.parallelDataNames(model.parallelDataNames);
            this.clientToken(model.clientToken);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final Collection<String> getTargetLanguageCodes() {
            if (this.targetLanguageCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetLanguageCodes;
        }

        @Override
        public final Builder targetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = TargetLanguageCodeStringListCopier.copy(targetLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLanguageCodes(String ... targetLanguageCodes) {
            this.targetLanguageCodes(Arrays.asList(targetLanguageCodes));
            return this;
        }

        public final void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = TargetLanguageCodeStringListCopier.copy(targetLanguageCodes);
        }

        public final Collection<String> getTerminologyNames() {
            if (this.terminologyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.terminologyNames;
        }

        @Override
        public final Builder terminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminologyNames(String ... terminologyNames) {
            this.terminologyNames(Arrays.asList(terminologyNames));
            return this;
        }

        public final void setTerminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
        }

        public final Collection<String> getParallelDataNames() {
            if (this.parallelDataNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parallelDataNames;
        }

        @Override
        public final Builder parallelDataNames(Collection<String> parallelDataNames) {
            this.parallelDataNames = ResourceNameListCopier.copy(parallelDataNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parallelDataNames(String ... parallelDataNames) {
            this.parallelDataNames(Arrays.asList(parallelDataNames));
            return this;
        }

        public final void setParallelDataNames(Collection<String> parallelDataNames) {
            this.parallelDataNames = ResourceNameListCopier.copy(parallelDataNames);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTextTranslationJobRequest build() {
            return new StartTextTranslationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTextTranslationJobRequest> {
        public Builder jobName(String var1);

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder dataAccessRoleArn(String var1);

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCodes(Collection<String> var1);

        public Builder targetLanguageCodes(String ... var1);

        public Builder terminologyNames(Collection<String> var1);

        public Builder terminologyNames(String ... var1);

        public Builder parallelDataNames(Collection<String> var1);

        public Builder parallelDataNames(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

