/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDetails> {
    private static final SdkField<Integer> TRANSLATED_DOCUMENTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobDetails.getter(JobDetails::translatedDocumentsCount)).setter(JobDetails.setter(Builder::translatedDocumentsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranslatedDocumentsCount").build()}).build();
    private static final SdkField<Integer> DOCUMENTS_WITH_ERRORS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobDetails.getter(JobDetails::documentsWithErrorsCount)).setter(JobDetails.setter(Builder::documentsWithErrorsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentsWithErrorsCount").build()}).build();
    private static final SdkField<Integer> INPUT_DOCUMENTS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobDetails.getter(JobDetails::inputDocumentsCount)).setter(JobDetails.setter(Builder::inputDocumentsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDocumentsCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATED_DOCUMENTS_COUNT_FIELD, DOCUMENTS_WITH_ERRORS_COUNT_FIELD, INPUT_DOCUMENTS_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer translatedDocumentsCount;
    private final Integer documentsWithErrorsCount;
    private final Integer inputDocumentsCount;

    private JobDetails(BuilderImpl builder) {
        this.translatedDocumentsCount = builder.translatedDocumentsCount;
        this.documentsWithErrorsCount = builder.documentsWithErrorsCount;
        this.inputDocumentsCount = builder.inputDocumentsCount;
    }

    public Integer translatedDocumentsCount() {
        return this.translatedDocumentsCount;
    }

    public Integer documentsWithErrorsCount() {
        return this.documentsWithErrorsCount;
    }

    public Integer inputDocumentsCount() {
        return this.inputDocumentsCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.translatedDocumentsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentsWithErrorsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDocumentsCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetails)) {
            return false;
        }
        JobDetails other = (JobDetails)obj;
        return Objects.equals(this.translatedDocumentsCount(), other.translatedDocumentsCount()) && Objects.equals(this.documentsWithErrorsCount(), other.documentsWithErrorsCount()) && Objects.equals(this.inputDocumentsCount(), other.inputDocumentsCount());
    }

    public String toString() {
        return ToString.builder((String)"JobDetails").add("TranslatedDocumentsCount", (Object)this.translatedDocumentsCount()).add("DocumentsWithErrorsCount", (Object)this.documentsWithErrorsCount()).add("InputDocumentsCount", (Object)this.inputDocumentsCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranslatedDocumentsCount": {
                return Optional.ofNullable(clazz.cast(this.translatedDocumentsCount()));
            }
            case "DocumentsWithErrorsCount": {
                return Optional.ofNullable(clazz.cast(this.documentsWithErrorsCount()));
            }
            case "InputDocumentsCount": {
                return Optional.ofNullable(clazz.cast(this.inputDocumentsCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDetails, T> g) {
        return obj -> g.apply((JobDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer translatedDocumentsCount;
        private Integer documentsWithErrorsCount;
        private Integer inputDocumentsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetails model) {
            this.translatedDocumentsCount(model.translatedDocumentsCount);
            this.documentsWithErrorsCount(model.documentsWithErrorsCount);
            this.inputDocumentsCount(model.inputDocumentsCount);
        }

        public final Integer getTranslatedDocumentsCount() {
            return this.translatedDocumentsCount;
        }

        @Override
        public final Builder translatedDocumentsCount(Integer translatedDocumentsCount) {
            this.translatedDocumentsCount = translatedDocumentsCount;
            return this;
        }

        public final void setTranslatedDocumentsCount(Integer translatedDocumentsCount) {
            this.translatedDocumentsCount = translatedDocumentsCount;
        }

        public final Integer getDocumentsWithErrorsCount() {
            return this.documentsWithErrorsCount;
        }

        @Override
        public final Builder documentsWithErrorsCount(Integer documentsWithErrorsCount) {
            this.documentsWithErrorsCount = documentsWithErrorsCount;
            return this;
        }

        public final void setDocumentsWithErrorsCount(Integer documentsWithErrorsCount) {
            this.documentsWithErrorsCount = documentsWithErrorsCount;
        }

        public final Integer getInputDocumentsCount() {
            return this.inputDocumentsCount;
        }

        @Override
        public final Builder inputDocumentsCount(Integer inputDocumentsCount) {
            this.inputDocumentsCount = inputDocumentsCount;
            return this;
        }

        public final void setInputDocumentsCount(Integer inputDocumentsCount) {
            this.inputDocumentsCount = inputDocumentsCount;
        }

        public JobDetails build() {
            return new JobDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDetails> {
        public Builder translatedDocumentsCount(Integer var1);

        public Builder documentsWithErrorsCount(Integer var1);

        public Builder inputDocumentsCount(Integer var1);
    }
}

