/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.ResourceNameListCopier;
import software.amazon.awssdk.services.translate.model.TranslateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranslateTextRequest
extends TranslateRequest
implements ToCopyableBuilder<Builder, TranslateTextRequest> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TranslateTextRequest.getter(TranslateTextRequest::text)).setter(TranslateTextRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<List<String>> TERMINOLOGY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TranslateTextRequest.getter(TranslateTextRequest::terminologyNames)).setter(TranslateTextRequest.setter(Builder::terminologyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TranslateTextRequest.getter(TranslateTextRequest::sourceLanguageCode)).setter(TranslateTextRequest.setter(Builder::sourceLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build()}).build();
    private static final SdkField<String> TARGET_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TranslateTextRequest.getter(TranslateTextRequest::targetLanguageCode)).setter(TranslateTextRequest.setter(Builder::targetLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, TERMINOLOGY_NAMES_FIELD, SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODE_FIELD));
    private final String text;
    private final List<String> terminologyNames;
    private final String sourceLanguageCode;
    private final String targetLanguageCode;

    private TranslateTextRequest(BuilderImpl builder) {
        super(builder);
        this.text = builder.text;
        this.terminologyNames = builder.terminologyNames;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
    }

    public String text() {
        return this.text;
    }

    public boolean hasTerminologyNames() {
        return this.terminologyNames != null && !(this.terminologyNames instanceof SdkAutoConstructList);
    }

    public List<String> terminologyNames() {
        return this.terminologyNames;
    }

    public String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public String targetLanguageCode() {
        return this.targetLanguageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminologyNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLanguageCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextRequest)) {
            return false;
        }
        TranslateTextRequest other = (TranslateTextRequest)((Object)obj);
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.terminologyNames(), other.terminologyNames()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && Objects.equals(this.targetLanguageCode(), other.targetLanguageCode());
    }

    public String toString() {
        return ToString.builder((String)"TranslateTextRequest").add("Text", (Object)this.text()).add("TerminologyNames", this.terminologyNames()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCode", (Object)this.targetLanguageCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "TerminologyNames": {
                return Optional.ofNullable(clazz.cast(this.terminologyNames()));
            }
            case "SourceLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.targetLanguageCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranslateTextRequest, T> g) {
        return obj -> g.apply((TranslateTextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateRequest.BuilderImpl
    implements Builder {
        private String text;
        private List<String> terminologyNames = DefaultSdkAutoConstructList.getInstance();
        private String sourceLanguageCode;
        private String targetLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateTextRequest model) {
            super(model);
            this.text(model.text);
            this.terminologyNames(model.terminologyNames);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCode(model.targetLanguageCode);
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Collection<String> getTerminologyNames() {
            return this.terminologyNames;
        }

        @Override
        public final Builder terminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminologyNames(String ... terminologyNames) {
            this.terminologyNames(Arrays.asList(terminologyNames));
            return this;
        }

        public final void setTerminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final String getTargetLanguageCode() {
            return this.targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TranslateTextRequest build() {
            return new TranslateTextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TranslateTextRequest> {
        public Builder text(String var1);

        public Builder terminologyNames(Collection<String> var1);

        public Builder terminologyNames(String ... var1);

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

