/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.services.translate.transform.TranslateTextRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TranslateTextRequestMarshaller
implements Marshaller<Request<TranslateTextRequest>, TranslateTextRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSShineFrontendService_20170701.TranslateText").serviceName("Amazon Translate").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public TranslateTextRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<TranslateTextRequest> marshall(TranslateTextRequest translateTextRequest) {
        Validate.paramNotNull((Object)((Object)translateTextRequest), (String)"translateTextRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)translateTextRequest);
            protocolMarshaller.startMarshalling();
            TranslateTextRequestModelMarshaller.getInstance().marshall(translateTextRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

