/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;

@SdkInternalApi
public class TranslateTextRequestModelMarshaller {
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").build();
    private static final MarshallingInfo<String> SOURCELANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceLanguageCode").build();
    private static final MarshallingInfo<String> TARGETLANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetLanguageCode").build();
    private static final TranslateTextRequestModelMarshaller INSTANCE = new TranslateTextRequestModelMarshaller();

    public static TranslateTextRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TranslateTextRequest translateTextRequest, ProtocolMarshaller protocolMarshaller) {
        if (translateTextRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)translateTextRequest.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)translateTextRequest.sourceLanguageCode(), SOURCELANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)translateTextRequest.targetLanguageCode(), TARGETLANGUAGECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

