/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranslateTextResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, TranslateTextResponse> {
    private static final SdkField<String> TRANSLATED_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TranslateTextResponse.getter(TranslateTextResponse::translatedText)).setter(TranslateTextResponse.setter(Builder::translatedText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranslatedText").build()}).build();
    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TranslateTextResponse.getter(TranslateTextResponse::sourceLanguageCode)).setter(TranslateTextResponse.setter(Builder::sourceLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build()}).build();
    private static final SdkField<String> TARGET_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TranslateTextResponse.getter(TranslateTextResponse::targetLanguageCode)).setter(TranslateTextResponse.setter(Builder::targetLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATED_TEXT_FIELD, SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODE_FIELD));
    private final String translatedText;
    private final String sourceLanguageCode;
    private final String targetLanguageCode;

    private TranslateTextResponse(BuilderImpl builder) {
        super(builder);
        this.translatedText = builder.translatedText;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
    }

    public String translatedText() {
        return this.translatedText;
    }

    public String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public String targetLanguageCode() {
        return this.targetLanguageCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.translatedText());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLanguageCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextResponse)) {
            return false;
        }
        TranslateTextResponse other = (TranslateTextResponse)((Object)obj);
        return Objects.equals(this.translatedText(), other.translatedText()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && Objects.equals(this.targetLanguageCode(), other.targetLanguageCode());
    }

    public String toString() {
        return ToString.builder((String)"TranslateTextResponse").add("TranslatedText", (Object)this.translatedText()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCode", (Object)this.targetLanguageCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranslatedText": {
                return Optional.ofNullable(clazz.cast(this.translatedText()));
            }
            case "SourceLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.targetLanguageCode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranslateTextResponse, T> g) {
        return obj -> g.apply((TranslateTextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private String translatedText;
        private String sourceLanguageCode;
        private String targetLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateTextResponse model) {
            super(model);
            this.translatedText(model.translatedText);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCode(model.targetLanguageCode);
        }

        public final String getTranslatedText() {
            return this.translatedText;
        }

        @Override
        public final Builder translatedText(String translatedText) {
            this.translatedText = translatedText;
            return this;
        }

        public final void setTranslatedText(String translatedText) {
            this.translatedText = translatedText;
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final String getTargetLanguageCode() {
            return this.targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        @Override
        public TranslateTextResponse build() {
            return new TranslateTextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TranslateTextResponse> {
        public Builder translatedText(String var1);

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCode(String var1);
    }
}

