/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAgreementsResponse extends TransferResponse implements
        ToCopyableBuilder<ListAgreementsResponse.Builder, ListAgreementsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAgreementsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListedAgreement>> AGREEMENTS_FIELD = SdkField
            .<List<ListedAgreement>> builder(MarshallingType.LIST)
            .memberName("Agreements")
            .getter(getter(ListAgreementsResponse::agreements))
            .setter(setter(Builder::agreements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agreements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedAgreement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedAgreement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            AGREEMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ListedAgreement> agreements;

    private ListAgreementsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.agreements = builder.agreements;
    }

    /**
     * <p>
     * Returns a token that you can use to call <code>ListAgreements</code> again and receive additional results, if
     * there are any.
     * </p>
     * 
     * @return Returns a token that you can use to call <code>ListAgreements</code> again and receive additional
     *         results, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Agreements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgreements() {
        return agreements != null && !(agreements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array, where each item contains the details of an agreement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgreements} method.
     * </p>
     * 
     * @return Returns an array, where each item contains the details of an agreement.
     */
    public final List<ListedAgreement> agreements() {
        return agreements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgreements() ? agreements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgreementsResponse)) {
            return false;
        }
        ListAgreementsResponse other = (ListAgreementsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasAgreements() == other.hasAgreements()
                && Objects.equals(agreements(), other.agreements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAgreementsResponse").add("NextToken", nextToken())
                .add("Agreements", hasAgreements() ? agreements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Agreements":
            return Optional.ofNullable(clazz.cast(agreements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Agreements", AGREEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAgreementsResponse, T> g) {
        return obj -> g.apply((ListAgreementsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAgreementsResponse> {
        /**
         * <p>
         * Returns a token that you can use to call <code>ListAgreements</code> again and receive additional results, if
         * there are any.
         * </p>
         * 
         * @param nextToken
         *        Returns a token that you can use to call <code>ListAgreements</code> again and receive additional
         *        results, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns an array, where each item contains the details of an agreement.
         * </p>
         * 
         * @param agreements
         *        Returns an array, where each item contains the details of an agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreements(Collection<ListedAgreement> agreements);

        /**
         * <p>
         * Returns an array, where each item contains the details of an agreement.
         * </p>
         * 
         * @param agreements
         *        Returns an array, where each item contains the details of an agreement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreements(ListedAgreement... agreements);

        /**
         * <p>
         * Returns an array, where each item contains the details of an agreement.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ListedAgreement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.transfer.model.ListedAgreement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ListedAgreement.Builder#build()} is called immediately
         * and its result is passed to {@link #agreements(List<ListedAgreement>)}.
         * 
         * @param agreements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ListedAgreement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agreements(java.util.Collection<ListedAgreement>)
         */
        Builder agreements(Consumer<ListedAgreement.Builder>... agreements);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListedAgreement> agreements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgreementsResponse model) {
            super(model);
            nextToken(model.nextToken);
            agreements(model.agreements);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListedAgreement.Builder> getAgreements() {
            List<ListedAgreement.Builder> result = ListedAgreementsCopier.copyToBuilder(this.agreements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgreements(Collection<ListedAgreement.BuilderImpl> agreements) {
            this.agreements = ListedAgreementsCopier.copyFromBuilder(agreements);
        }

        @Override
        public final Builder agreements(Collection<ListedAgreement> agreements) {
            this.agreements = ListedAgreementsCopier.copy(agreements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreements(ListedAgreement... agreements) {
            agreements(Arrays.asList(agreements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreements(Consumer<ListedAgreement.Builder>... agreements) {
            agreements(Stream.of(agreements).map(c -> ListedAgreement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAgreementsResponse build() {
            return new ListAgreementsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
