/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes the parameters for the web app, as identified by the <code>WebAppId</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedWebApp implements SdkPojo, Serializable, ToCopyableBuilder<DescribedWebApp.Builder, DescribedWebApp> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribedWebApp::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppId").getter(getter(DescribedWebApp::webAppId)).setter(setter(Builder::webAppId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()).build();

    private static final SdkField<DescribedWebAppIdentityProviderDetails> DESCRIBED_IDENTITY_PROVIDER_DETAILS_FIELD = SdkField
            .<DescribedWebAppIdentityProviderDetails> builder(MarshallingType.SDK_POJO)
            .memberName("DescribedIdentityProviderDetails")
            .getter(getter(DescribedWebApp::describedIdentityProviderDetails))
            .setter(setter(Builder::describedIdentityProviderDetails))
            .constructor(DescribedWebAppIdentityProviderDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescribedIdentityProviderDetails")
                    .build()).build();

    private static final SdkField<String> ACCESS_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessEndpoint").getter(getter(DescribedWebApp::accessEndpoint)).setter(setter(Builder::accessEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoint").build()).build();

    private static final SdkField<String> WEB_APP_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppEndpoint").getter(getter(DescribedWebApp::webAppEndpoint)).setter(setter(Builder::webAppEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppEndpoint").build()).build();

    private static final SdkField<WebAppUnits> WEB_APP_UNITS_FIELD = SdkField.<WebAppUnits> builder(MarshallingType.SDK_POJO)
            .memberName("WebAppUnits").getter(getter(DescribedWebApp::webAppUnits)).setter(setter(Builder::webAppUnits))
            .constructor(WebAppUnits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppUnits").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(DescribedWebApp::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WEB_APP_ENDPOINT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppEndpointPolicy").getter(getter(DescribedWebApp::webAppEndpointPolicyAsString))
            .setter(setter(Builder::webAppEndpointPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppEndpointPolicy").build())
            .build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(DescribedWebApp::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<DescribedWebAppEndpointDetails> DESCRIBED_ENDPOINT_DETAILS_FIELD = SdkField
            .<DescribedWebAppEndpointDetails> builder(MarshallingType.SDK_POJO).memberName("DescribedEndpointDetails")
            .getter(getter(DescribedWebApp::describedEndpointDetails)).setter(setter(Builder::describedEndpointDetails))
            .constructor(DescribedWebAppEndpointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DescribedEndpointDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WEB_APP_ID_FIELD,
            DESCRIBED_IDENTITY_PROVIDER_DETAILS_FIELD, ACCESS_ENDPOINT_FIELD, WEB_APP_ENDPOINT_FIELD, WEB_APP_UNITS_FIELD,
            TAGS_FIELD, WEB_APP_ENDPOINT_POLICY_FIELD, ENDPOINT_TYPE_FIELD, DESCRIBED_ENDPOINT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String webAppId;

    private final DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails;

    private final String accessEndpoint;

    private final String webAppEndpoint;

    private final WebAppUnits webAppUnits;

    private final List<Tag> tags;

    private final String webAppEndpointPolicy;

    private final String endpointType;

    private final DescribedWebAppEndpointDetails describedEndpointDetails;

    private DescribedWebApp(BuilderImpl builder) {
        this.arn = builder.arn;
        this.webAppId = builder.webAppId;
        this.describedIdentityProviderDetails = builder.describedIdentityProviderDetails;
        this.accessEndpoint = builder.accessEndpoint;
        this.webAppEndpoint = builder.webAppEndpoint;
        this.webAppUnits = builder.webAppUnits;
        this.tags = builder.tags;
        this.webAppEndpointPolicy = builder.webAppEndpointPolicy;
        this.endpointType = builder.endpointType;
        this.describedEndpointDetails = builder.describedEndpointDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the web app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the web app.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the web app.
     * </p>
     * 
     * @return The unique identifier for the web app.
     */
    public final String webAppId() {
        return webAppId;
    }

    /**
     * <p>
     * A structure that contains the details for the identity provider used by the web app.
     * </p>
     * 
     * @return A structure that contains the details for the identity provider used by the web app.
     */
    public final DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails() {
        return describedIdentityProviderDetails;
    }

    /**
     * <p>
     * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer
     * Family web app. You can specify a custom URL or use the default value.
     * </p>
     * 
     * @return The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the
     *         Transfer Family web app. You can specify a custom URL or use the default value.
     */
    public final String accessEndpoint() {
        return accessEndpoint;
    }

    /**
     * <p>
     * The <code>WebAppEndpoint</code> is the unique URL for your Transfer Family web app. This is the value that you
     * use when you configure <b>Origins</b> on CloudFront.
     * </p>
     * 
     * @return The <code>WebAppEndpoint</code> is the unique URL for your Transfer Family web app. This is the value
     *         that you use when you configure <b>Origins</b> on CloudFront.
     */
    public final String webAppEndpoint() {
        return webAppEndpoint;
    }

    /**
     * <p>
     * A union that contains the value for number of concurrent connections or the user sessions on your web app.
     * </p>
     * 
     * @return A union that contains the value for number of concurrent connections or the user sessions on your web
     *         app.
     */
    public final WebAppUnits webAppUnits() {
        return webAppUnits;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for web apps. Tags are metadata attached to web apps for any
     * purpose.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for web apps. Tags are metadata attached to web apps
     *         for any purpose.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
     * </p>
     * <p>
     * If your web app was created in an Amazon Web Services GovCloud (US) Region, the value of this parameter can be
     * <code>FIPS</code>, which indicates the web app endpoint is FIPS-compliant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webAppEndpointPolicy} will return {@link WebAppEndpointPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webAppEndpointPolicyAsString}.
     * </p>
     * 
     * @return Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>. </p>
     *         <p>
     *         If your web app was created in an Amazon Web Services GovCloud (US) Region, the value of this parameter
     *         can be <code>FIPS</code>, which indicates the web app endpoint is FIPS-compliant.
     * @see WebAppEndpointPolicy
     */
    public final WebAppEndpointPolicy webAppEndpointPolicy() {
        return WebAppEndpointPolicy.fromValue(webAppEndpointPolicy);
    }

    /**
     * <p>
     * Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
     * </p>
     * <p>
     * If your web app was created in an Amazon Web Services GovCloud (US) Region, the value of this parameter can be
     * <code>FIPS</code>, which indicates the web app endpoint is FIPS-compliant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webAppEndpointPolicy} will return {@link WebAppEndpointPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webAppEndpointPolicyAsString}.
     * </p>
     * 
     * @return Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>. </p>
     *         <p>
     *         If your web app was created in an Amazon Web Services GovCloud (US) Region, the value of this parameter
     *         can be <code>FIPS</code>, which indicates the web app endpoint is FIPS-compliant.
     * @see WebAppEndpointPolicy
     */
    public final String webAppEndpointPolicyAsString() {
        return webAppEndpointPolicy;
    }

    /**
     * <p>
     * The type of endpoint hosting the web app. Valid values are <code>PUBLIC</code> for publicly accessible endpoints
     * and <code>VPC</code> for VPC-hosted endpoints that provide network isolation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link WebAppEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint hosting the web app. Valid values are <code>PUBLIC</code> for publicly accessible
     *         endpoints and <code>VPC</code> for VPC-hosted endpoints that provide network isolation.
     * @see WebAppEndpointType
     */
    public final WebAppEndpointType endpointType() {
        return WebAppEndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of endpoint hosting the web app. Valid values are <code>PUBLIC</code> for publicly accessible endpoints
     * and <code>VPC</code> for VPC-hosted endpoints that provide network isolation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link WebAppEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint hosting the web app. Valid values are <code>PUBLIC</code> for publicly accessible
     *         endpoints and <code>VPC</code> for VPC-hosted endpoints that provide network isolation.
     * @see WebAppEndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The endpoint configuration details for the web app, including VPC settings if the endpoint is hosted within a
     * VPC.
     * </p>
     * 
     * @return The endpoint configuration details for the web app, including VPC settings if the endpoint is hosted
     *         within a VPC.
     */
    public final DescribedWebAppEndpointDetails describedEndpointDetails() {
        return describedEndpointDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(describedIdentityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(accessEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(webAppEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(webAppUnits());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(webAppEndpointPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(describedEndpointDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedWebApp)) {
            return false;
        }
        DescribedWebApp other = (DescribedWebApp) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(webAppId(), other.webAppId())
                && Objects.equals(describedIdentityProviderDetails(), other.describedIdentityProviderDetails())
                && Objects.equals(accessEndpoint(), other.accessEndpoint())
                && Objects.equals(webAppEndpoint(), other.webAppEndpoint()) && Objects.equals(webAppUnits(), other.webAppUnits())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(webAppEndpointPolicyAsString(), other.webAppEndpointPolicyAsString())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(describedEndpointDetails(), other.describedEndpointDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedWebApp").add("Arn", arn()).add("WebAppId", webAppId())
                .add("DescribedIdentityProviderDetails", describedIdentityProviderDetails())
                .add("AccessEndpoint", accessEndpoint()).add("WebAppEndpoint", webAppEndpoint())
                .add("WebAppUnits", webAppUnits()).add("Tags", hasTags() ? tags() : null)
                .add("WebAppEndpointPolicy", webAppEndpointPolicyAsString()).add("EndpointType", endpointTypeAsString())
                .add("DescribedEndpointDetails", describedEndpointDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "WebAppId":
            return Optional.ofNullable(clazz.cast(webAppId()));
        case "DescribedIdentityProviderDetails":
            return Optional.ofNullable(clazz.cast(describedIdentityProviderDetails()));
        case "AccessEndpoint":
            return Optional.ofNullable(clazz.cast(accessEndpoint()));
        case "WebAppEndpoint":
            return Optional.ofNullable(clazz.cast(webAppEndpoint()));
        case "WebAppUnits":
            return Optional.ofNullable(clazz.cast(webAppUnits()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WebAppEndpointPolicy":
            return Optional.ofNullable(clazz.cast(webAppEndpointPolicyAsString()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "DescribedEndpointDetails":
            return Optional.ofNullable(clazz.cast(describedEndpointDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("WebAppId", WEB_APP_ID_FIELD);
        map.put("DescribedIdentityProviderDetails", DESCRIBED_IDENTITY_PROVIDER_DETAILS_FIELD);
        map.put("AccessEndpoint", ACCESS_ENDPOINT_FIELD);
        map.put("WebAppEndpoint", WEB_APP_ENDPOINT_FIELD);
        map.put("WebAppUnits", WEB_APP_UNITS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WebAppEndpointPolicy", WEB_APP_ENDPOINT_POLICY_FIELD);
        map.put("EndpointType", ENDPOINT_TYPE_FIELD);
        map.put("DescribedEndpointDetails", DESCRIBED_ENDPOINT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedWebApp, T> g) {
        return obj -> g.apply((DescribedWebApp) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedWebApp> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the web app.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the web app.
         * </p>
         * 
         * @param webAppId
         *        The unique identifier for the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppId(String webAppId);

        /**
         * <p>
         * A structure that contains the details for the identity provider used by the web app.
         * </p>
         * 
         * @param describedIdentityProviderDetails
         *        A structure that contains the details for the identity provider used by the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder describedIdentityProviderDetails(DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails);

        /**
         * <p>
         * A structure that contains the details for the identity provider used by the web app.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DescribedWebAppIdentityProviderDetails.Builder} avoiding the need to create one manually via
         * {@link DescribedWebAppIdentityProviderDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedWebAppIdentityProviderDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #describedIdentityProviderDetails(DescribedWebAppIdentityProviderDetails)}.
         * 
         * @param describedIdentityProviderDetails
         *        a consumer that will call methods on {@link DescribedWebAppIdentityProviderDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #describedIdentityProviderDetails(DescribedWebAppIdentityProviderDetails)
         */
        default Builder describedIdentityProviderDetails(
                Consumer<DescribedWebAppIdentityProviderDetails.Builder> describedIdentityProviderDetails) {
            return describedIdentityProviderDetails(DescribedWebAppIdentityProviderDetails.builder()
                    .applyMutation(describedIdentityProviderDetails).build());
        }

        /**
         * <p>
         * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the
         * Transfer Family web app. You can specify a custom URL or use the default value.
         * </p>
         * 
         * @param accessEndpoint
         *        The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with
         *        the Transfer Family web app. You can specify a custom URL or use the default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoint(String accessEndpoint);

        /**
         * <p>
         * The <code>WebAppEndpoint</code> is the unique URL for your Transfer Family web app. This is the value that
         * you use when you configure <b>Origins</b> on CloudFront.
         * </p>
         * 
         * @param webAppEndpoint
         *        The <code>WebAppEndpoint</code> is the unique URL for your Transfer Family web app. This is the value
         *        that you use when you configure <b>Origins</b> on CloudFront.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppEndpoint(String webAppEndpoint);

        /**
         * <p>
         * A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * </p>
         * 
         * @param webAppUnits
         *        A union that contains the value for number of concurrent connections or the user sessions on your web
         *        app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppUnits(WebAppUnits webAppUnits);

        /**
         * <p>
         * A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebAppUnits.Builder} avoiding the need to
         * create one manually via {@link WebAppUnits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebAppUnits.Builder#build()} is called immediately and its result
         * is passed to {@link #webAppUnits(WebAppUnits)}.
         * 
         * @param webAppUnits
         *        a consumer that will call methods on {@link WebAppUnits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webAppUnits(WebAppUnits)
         */
        default Builder webAppUnits(Consumer<WebAppUnits.Builder> webAppUnits) {
            return webAppUnits(WebAppUnits.builder().applyMutation(webAppUnits).build());
        }

        /**
         * <p>
         * Key-value pairs that can be used to group and search for web apps. Tags are metadata attached to web apps for
         * any purpose.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for web apps. Tags are metadata attached to web
         *        apps for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for web apps. Tags are metadata attached to web apps for
         * any purpose.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for web apps. Tags are metadata attached to web
         *        apps for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for web apps. Tags are metadata attached to web apps for
         * any purpose.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transfer.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
         * </p>
         * <p>
         * If your web app was created in an Amazon Web Services GovCloud (US) Region, the value of this parameter can
         * be <code>FIPS</code>, which indicates the web app endpoint is FIPS-compliant.
         * </p>
         * 
         * @param webAppEndpointPolicy
         *        Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
         *        </p>
         *        <p>
         *        If your web app was created in an Amazon Web Services GovCloud (US) Region, the value of this
         *        parameter can be <code>FIPS</code>, which indicates the web app endpoint is FIPS-compliant.
         * @see WebAppEndpointPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebAppEndpointPolicy
         */
        Builder webAppEndpointPolicy(String webAppEndpointPolicy);

        /**
         * <p>
         * Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
         * </p>
         * <p>
         * If your web app was created in an Amazon Web Services GovCloud (US) Region, the value of this parameter can
         * be <code>FIPS</code>, which indicates the web app endpoint is FIPS-compliant.
         * </p>
         * 
         * @param webAppEndpointPolicy
         *        Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
         *        </p>
         *        <p>
         *        If your web app was created in an Amazon Web Services GovCloud (US) Region, the value of this
         *        parameter can be <code>FIPS</code>, which indicates the web app endpoint is FIPS-compliant.
         * @see WebAppEndpointPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebAppEndpointPolicy
         */
        Builder webAppEndpointPolicy(WebAppEndpointPolicy webAppEndpointPolicy);

        /**
         * <p>
         * The type of endpoint hosting the web app. Valid values are <code>PUBLIC</code> for publicly accessible
         * endpoints and <code>VPC</code> for VPC-hosted endpoints that provide network isolation.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint hosting the web app. Valid values are <code>PUBLIC</code> for publicly accessible
         *        endpoints and <code>VPC</code> for VPC-hosted endpoints that provide network isolation.
         * @see WebAppEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebAppEndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of endpoint hosting the web app. Valid values are <code>PUBLIC</code> for publicly accessible
         * endpoints and <code>VPC</code> for VPC-hosted endpoints that provide network isolation.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint hosting the web app. Valid values are <code>PUBLIC</code> for publicly accessible
         *        endpoints and <code>VPC</code> for VPC-hosted endpoints that provide network isolation.
         * @see WebAppEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebAppEndpointType
         */
        Builder endpointType(WebAppEndpointType endpointType);

        /**
         * <p>
         * The endpoint configuration details for the web app, including VPC settings if the endpoint is hosted within a
         * VPC.
         * </p>
         * 
         * @param describedEndpointDetails
         *        The endpoint configuration details for the web app, including VPC settings if the endpoint is hosted
         *        within a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder describedEndpointDetails(DescribedWebAppEndpointDetails describedEndpointDetails);

        /**
         * <p>
         * The endpoint configuration details for the web app, including VPC settings if the endpoint is hosted within a
         * VPC.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedWebAppEndpointDetails.Builder}
         * avoiding the need to create one manually via {@link DescribedWebAppEndpointDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedWebAppEndpointDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #describedEndpointDetails(DescribedWebAppEndpointDetails)}.
         * 
         * @param describedEndpointDetails
         *        a consumer that will call methods on {@link DescribedWebAppEndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #describedEndpointDetails(DescribedWebAppEndpointDetails)
         */
        default Builder describedEndpointDetails(Consumer<DescribedWebAppEndpointDetails.Builder> describedEndpointDetails) {
            return describedEndpointDetails(DescribedWebAppEndpointDetails.builder().applyMutation(describedEndpointDetails)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String webAppId;

        private DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails;

        private String accessEndpoint;

        private String webAppEndpoint;

        private WebAppUnits webAppUnits;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String webAppEndpointPolicy;

        private String endpointType;

        private DescribedWebAppEndpointDetails describedEndpointDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedWebApp model) {
            arn(model.arn);
            webAppId(model.webAppId);
            describedIdentityProviderDetails(model.describedIdentityProviderDetails);
            accessEndpoint(model.accessEndpoint);
            webAppEndpoint(model.webAppEndpoint);
            webAppUnits(model.webAppUnits);
            tags(model.tags);
            webAppEndpointPolicy(model.webAppEndpointPolicy);
            endpointType(model.endpointType);
            describedEndpointDetails(model.describedEndpointDetails);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWebAppId() {
            return webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final DescribedWebAppIdentityProviderDetails.Builder getDescribedIdentityProviderDetails() {
            return describedIdentityProviderDetails != null ? describedIdentityProviderDetails.toBuilder() : null;
        }

        public final void setDescribedIdentityProviderDetails(
                DescribedWebAppIdentityProviderDetails.BuilderImpl describedIdentityProviderDetails) {
            this.describedIdentityProviderDetails = describedIdentityProviderDetails != null ? describedIdentityProviderDetails
                    .build() : null;
        }

        @Override
        public final Builder describedIdentityProviderDetails(
                DescribedWebAppIdentityProviderDetails describedIdentityProviderDetails) {
            this.describedIdentityProviderDetails = describedIdentityProviderDetails;
            return this;
        }

        public final String getAccessEndpoint() {
            return accessEndpoint;
        }

        public final void setAccessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
        }

        @Override
        public final Builder accessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
            return this;
        }

        public final String getWebAppEndpoint() {
            return webAppEndpoint;
        }

        public final void setWebAppEndpoint(String webAppEndpoint) {
            this.webAppEndpoint = webAppEndpoint;
        }

        @Override
        public final Builder webAppEndpoint(String webAppEndpoint) {
            this.webAppEndpoint = webAppEndpoint;
            return this;
        }

        public final WebAppUnits.Builder getWebAppUnits() {
            return webAppUnits != null ? webAppUnits.toBuilder() : null;
        }

        public final void setWebAppUnits(WebAppUnits.BuilderImpl webAppUnits) {
            this.webAppUnits = webAppUnits != null ? webAppUnits.build() : null;
        }

        @Override
        public final Builder webAppUnits(WebAppUnits webAppUnits) {
            this.webAppUnits = webAppUnits;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWebAppEndpointPolicy() {
            return webAppEndpointPolicy;
        }

        public final void setWebAppEndpointPolicy(String webAppEndpointPolicy) {
            this.webAppEndpointPolicy = webAppEndpointPolicy;
        }

        @Override
        public final Builder webAppEndpointPolicy(String webAppEndpointPolicy) {
            this.webAppEndpointPolicy = webAppEndpointPolicy;
            return this;
        }

        @Override
        public final Builder webAppEndpointPolicy(WebAppEndpointPolicy webAppEndpointPolicy) {
            this.webAppEndpointPolicy(webAppEndpointPolicy == null ? null : webAppEndpointPolicy.toString());
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(WebAppEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final DescribedWebAppEndpointDetails.Builder getDescribedEndpointDetails() {
            return describedEndpointDetails != null ? describedEndpointDetails.toBuilder() : null;
        }

        public final void setDescribedEndpointDetails(DescribedWebAppEndpointDetails.BuilderImpl describedEndpointDetails) {
            this.describedEndpointDetails = describedEndpointDetails != null ? describedEndpointDetails.build() : null;
        }

        @Override
        public final Builder describedEndpointDetails(DescribedWebAppEndpointDetails describedEndpointDetails) {
            this.describedEndpointDetails = describedEndpointDetails;
            return this;
        }

        @Override
        public DescribedWebApp build() {
            return new DescribedWebApp(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
